/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.Provider;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamException;
import org.infinispan.Version;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.time.DefaultTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.RestServer;
import org.infinispan.server.DefaultExitHandler;
import org.infinispan.server.ExitHandler;
import org.infinispan.server.SecurityActions;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.admin.ServerAdminOperationsHandler;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.logging.Log;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.router.impl.singleport.SinglePortEndpointRouter;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.infinispan.server.router.routes.hotrod.HotRodServerRouteDestination;
import org.infinispan.server.router.routes.rest.RestServerRouteDestination;
import org.infinispan.server.router.routes.singleport.SinglePortRouteSource;
import org.infinispan.util.logging.LogFactory;
import org.wildfly.security.WildFlyElytronProvider;

public class Server {
    public static final Log log = (Log)LogFactory.getLog((String)"SERVER", Log.class);
    public static final String INFINISPAN_BIND_ADDRESS = "infinispan.bind.address";
    public static final String INFINISPAN_CLUSTER_NAME = "infinispan.cluster.name";
    public static final String INFINISPAN_NODE_NAME = "infinispan.node.name";
    public static final String INFINISPAN_PORT_OFFSET = "infinispan.socket.binding.port-offset";
    public static final String INFINISPAN_SERVER_HOME_PATH = "infinispan.server.home.path";
    public static final String INFINISPAN_SERVER_ROOT_PATH = "infinispan.server.root.path";
    public static final String INFINISPAN_SERVER_CONFIG_PATH = "infinispan.server.config.path";
    public static final String INFINISPAN_SERVER_DATA_PATH = "infinispan.server.data.path";
    public static final String INFINISPAN_SERVER_LOG_PATH = "infinispan.server.log.path";
    private static final String SERVER_DEFAULTS = "infinispan-defaults.xml";
    public static final String DEFAULT_SERVER_CONFIG = "conf";
    public static final String DEFAULT_SERVER_DATA = "data";
    public static final String DEFAULT_SERVER_LIB = "lib";
    public static final String DEFAULT_SERVER_LOG = "log";
    public static final String DEFAULT_SERVER_ROOT_DIR = "server";
    public static final String DEFAULT_CONFIGURATION_FILE = "infinispan.xml";
    private final TimeService timeService;
    private final File serverRoot;
    private final File serverConf;
    private final long startTime;
    private final Properties properties;
    private ExitHandler exitHandler = new DefaultExitHandler();
    private ConfigurationBuilderHolder defaultsHolder;
    private ConfigurationBuilderHolder configurationBuilderHolder;
    private Map<String, DefaultCacheManager> cacheManagers;
    private Map<String, ProtocolServer> protocolServers;
    private volatile ComponentStatus status;

    public Server() {
        this(new File(DEFAULT_SERVER_ROOT_DIR), new File(DEFAULT_CONFIGURATION_FILE), SecurityActions.getSystemProperties());
    }

    public Server(File serverRoot, File configuration, Properties properties) {
        this(serverRoot, properties);
        if (!configuration.isAbsolute()) {
            configuration = new File(this.serverConf, configuration.getPath());
        }
        try {
            this.parseConfiguration(configuration.toURI().toURL());
        }
        catch (IOException e) {
            throw new CacheConfigurationException((Exception)e);
        }
    }

    private Server(File serverRoot, Properties properties) {
        this.timeService = DefaultTimeService.INSTANCE;
        this.startTime = this.timeService.time();
        this.serverRoot = serverRoot;
        this.properties = properties;
        this.status = ComponentStatus.INSTANTIATED;
        properties.putIfAbsent(INFINISPAN_SERVER_ROOT_PATH, serverRoot);
        properties.putIfAbsent(INFINISPAN_SERVER_CONFIG_PATH, new File(serverRoot, DEFAULT_SERVER_CONFIG).getAbsolutePath());
        properties.putIfAbsent(INFINISPAN_SERVER_DATA_PATH, new File(serverRoot, DEFAULT_SERVER_DATA).getAbsolutePath());
        properties.putIfAbsent(INFINISPAN_SERVER_LOG_PATH, new File(serverRoot, DEFAULT_SERVER_LOG).getAbsolutePath());
        this.serverConf = new File(properties.getProperty(INFINISPAN_SERVER_CONFIG_PATH));
        SecurityActions.addSecurityProvider((Provider)new WildFlyElytronProvider());
    }

    private void parseConfiguration(URL config) {
        ParserRegistry parser = new ParserRegistry(this.getClass().getClassLoader(), false, this.properties);
        try {
            URL defaults = this.getClass().getClassLoader().getResource(SERVER_DEFAULTS);
            this.defaultsHolder = parser.parse(defaults);
            this.configurationBuilderHolder = new ConfigurationBuilderHolder();
            this.configurationBuilderHolder.getGlobalConfigurationBuilder().read(this.defaultsHolder.getGlobalConfigurationBuilder().build());
            for (Map.Entry entry : this.defaultsHolder.getNamedConfigurationBuilders().entrySet()) {
                this.configurationBuilderHolder.newConfigurationBuilder((String)entry.getKey()).read(((ConfigurationBuilder)entry.getValue()).build());
            }
            this.configurationBuilderHolder = parser.parse(config, this.configurationBuilderHolder);
            ServerAdminOperationsHandler adminOperationsHandler = new ServerAdminOperationsHandler(this.defaultsHolder);
            ServerConfigurationBuilder serverConfigurationBuilder = (ServerConfigurationBuilder)this.configurationBuilderHolder.getGlobalConfigurationBuilder().module(ServerConfigurationBuilder.class);
            serverConfigurationBuilder.connectors().forEach(builder -> builder.adminOperationsHandler((AdminOperationsHandler)adminOperationsHandler));
            for (Map.Entry entry : this.configurationBuilderHolder.getNamedConfigurationBuilders().entrySet()) {
                Configuration cfg = ((ConfigurationBuilder)entry.getValue()).build();
                ConfigurationBuilder defaultCfg = (ConfigurationBuilder)this.defaultsHolder.getNamedConfigurationBuilders().get("org.infinispan." + cfg.clustering().cacheMode().name());
                ConfigurationBuilder rebased = new ConfigurationBuilder().read(defaultCfg.build());
                rebased.read(cfg);
                entry.setValue(rebased);
            }
            this.configurationBuilderHolder.validate();
        }
        catch (IOException | XMLStreamException e) {
            throw new CacheConfigurationException(e);
        }
    }

    public ExitHandler getExitHandler() {
        return this.exitHandler;
    }

    public void setExitHandler(ExitHandler exitHandler) {
        if (this.status != ComponentStatus.INSTANTIATED) {
            throw new IllegalStateException("Cannot change exit handler on a running server");
        }
        this.exitHandler = exitHandler;
    }

    public synchronized CompletableFuture<Integer> run() {
        CompletionStage<Integer> r = this.exitHandler.getExitFuture();
        if (this.status == ComponentStatus.RUNNING) {
            return r;
        }
        this.cacheManagers = new LinkedHashMap<String, DefaultCacheManager>(1);
        this.protocolServers = new LinkedHashMap<String, ProtocolServer>(3);
        try {
            DefaultCacheManager cm = new DefaultCacheManager(this.configurationBuilderHolder, true);
            this.cacheManagers.put(cm.getName(), cm);
            ServerConfiguration serverConfiguration = (ServerConfiguration)cm.getCacheManagerConfiguration().module(ServerConfiguration.class);
            SinglePortRouteSource routeSource = new SinglePortRouteSource();
            ConcurrentHashMap routes = new ConcurrentHashMap();
            serverConfiguration.connectors().parallelStream().forEach(configuration -> {
                Class<ProtocolServer> protocolServerClass = configuration.getClass().getAnnotation(ConfigurationFor.class).value().asSubclass(ProtocolServer.class);
                ProtocolServer protocolServer = (ProtocolServer)Util.getInstance(protocolServerClass);
                this.protocolServers.put(protocolServer.getName() + "-" + configuration.name(), protocolServer);
                protocolServer.start(configuration, (EmbeddedCacheManager)cm);
                ProtocolServerConfiguration protocolConfig = protocolServer.getConfiguration();
                if (protocolConfig.startTransport()) {
                    log.protocolStarted(protocolServer.getName(), protocolConfig.host(), protocolConfig.port());
                } else {
                    if (protocolServer instanceof HotRodServer) {
                        routes.put(new Route((RouteSource)routeSource, (RouteDestination)new HotRodServerRouteDestination(protocolServer.getName(), (HotRodServer)protocolServer)), 0);
                    } else if (protocolServer instanceof RestServer) {
                        routes.put(new Route((RouteSource)routeSource, (RouteDestination)new RestServerRouteDestination(protocolServer.getName(), (RestServer)protocolServer)), 0);
                    }
                    log.protocolStarted(protocolServer.getName());
                }
            });
            SinglePortEndpointRouter endpointServer = new SinglePortEndpointRouter(serverConfiguration.endpoint());
            endpointServer.start(new RoutingTable(routes.keySet()));
            this.protocolServers.put("endpoint", (ProtocolServer)endpointServer);
            log.protocolStarted(endpointServer.getName(), serverConfiguration.endpoint().host(), serverConfiguration.endpoint().port());
            this.status = ComponentStatus.RUNNING;
            log.serverStarted(Version.getBrandName(), Version.getVersion(), this.timeService.timeDuration(this.startTime, TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            r.completeExceptionally(e);
        }
        r = r.whenComplete((status, t) -> this.shutdown());
        return r;
    }

    private void shutdown() {
        this.status = ComponentStatus.STOPPING;
        this.protocolServers.values().parallelStream().forEach(ps -> ps.stop());
        this.cacheManagers.values().forEach(cm -> cm.stop());
        this.status = ComponentStatus.TERMINATED;
    }

    public ConfigurationBuilderHolder getConfigurationBuilderHolder() {
        return this.configurationBuilderHolder;
    }

    public File getServerRoot() {
        return this.serverRoot;
    }

    public Map<String, DefaultCacheManager> getCacheManagers() {
        return this.cacheManagers;
    }

    public Map<String, ProtocolServer> getProtocolServers() {
        return this.protocolServers;
    }
}

