/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    GLOBAL,
    INET_ADDRESS,
    INTERFACE,
    INTERFACES,
    KEYSTORE,
    LINK_LOCAL,
    LOOPBACK,
    MATCH_ADDRESS,
    MATCH_HOST,
    MATCH_INTERFACE,
    NON_LOOPBACK,
    PATH,
    PATHS,
    PROPERTIES,
    SECURITY,
    SECURITY_REALM,
    SECURITY_REALMS,
    SERVER,
    SERVER_IDENTITIES,
    SITE_LOCAL,
    SOCKET_BINDING,
    SOCKET_BINDINGS,
    SSL,
    ENDPOINTS,
    TRUSTSTORE,
    LOCAL,
    KERBEROS,
    ENGINE,
    PROPERTIES_REALM,
    KERBEROS_REALM,
    LOCAL_REALM,
    USER_PROPERTIES,
    GROUP_PROPERTIES,
    TRUSTSTORE_REALM,
    LDAP_REALM,
    IDENTITY_MAPPING,
    ATTRIBUTE_MAPPING,
    ATTRIBUTE,
    USER_PASSWORD_MAPPER,
    TOKEN_REALM,
    OAUTH2_INTROSPECTION,
    JWT,
    FILESYSTEM_REALM;

    private static final Map<String, Element> ELEMENTS;
    private final String name;

    private Element(String name) {
        this.name = name;
    }

    private Element() {
        this.name = this.name().toLowerCase().replace('_', '-');
    }

    public static Element forName(String localName) {
        Element element = ELEMENTS.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>(8);
        for (Element element : Element.values()) {
            String name = element.name;
            if (name == null) continue;
            map.put(name, element);
        }
        ELEMENTS = map;
    }
}

