/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Permission;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.security.HostnameVerificationPolicy;
import org.infinispan.server.security.KeyStoreUtils;
import org.infinispan.server.security.realm.KerberosSecurityRealm;
import org.infinispan.server.security.realm.PropertiesSecurityRealm;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.realm.ldap.AttributeMapping;
import org.wildfly.security.auth.realm.ldap.DirContextFactory;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.realm.ldap.SimpleDirContextFactoryBuilder;
import org.wildfly.security.auth.realm.token.TokenSecurityRealm;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.realm.token.validator.JwtValidator;
import org.wildfly.security.auth.realm.token.validator.OAuth2IntrospectValidator;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.keystore.AliasFilter;
import org.wildfly.security.keystore.FilteringKeyStore;
import org.wildfly.security.keystore.KeyStoreUtil;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.provider.util.ProviderUtil;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLContextBuilder;

@Namespaces(value={@Namespace(root="server"), @Namespace(uri="urn:infinispan:server:*", root="server")})
public class ServerConfigurationParser
implements ConfigurationParser {
    private static Log coreLog = LogFactory.getLog(ServerConfigurationParser.class);
    public static String ENDPOINTS_SCOPE = "ENDPOINTS";

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    public static Element nextElement(XMLStreamReader reader) throws XMLStreamException {
        if (reader.nextTag() == 2) {
            return null;
        }
        return Element.forName(reader.getLocalName());
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        if (!holder.inScope((Enum)ParserScope.GLOBAL)) {
            throw coreLog.invalidScope(ParserScope.GLOBAL.name(), holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case SERVER: {
                ((PrivateGlobalConfigurationBuilder)builder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
                ServerConfigurationBuilder serverConfigurationBuilder = (ServerConfigurationBuilder)builder.addModule(ServerConfigurationBuilder.class);
                this.parseServerElements(reader, holder, serverConfigurationBuilder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseServerElements(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ServerConfigurationBuilder builder) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERFACES: {
                    this.parseInterfaces(reader, builder);
                    continue block6;
                }
                case SOCKET_BINDINGS: {
                    this.parseSocketBindings(reader, builder);
                    continue block6;
                }
                case SECURITY: {
                    this.parseSecurity(reader, builder);
                    continue block6;
                }
                case ENDPOINTS: {
                    this.parseEndpoints(reader, holder, builder);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSocketBindings(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.DEFAULT_INTERFACE, Attribute.PORT_OFFSET});
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING: {
                    this.parseSocketBinding(reader, builder, attributes[0], Integer.parseInt(attributes[1]));
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSocketBinding(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder, String defaultInterfaceName, int portOffset) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.NAME, Attribute.PORT});
        String name = attributes[0];
        int port = Integer.parseInt(attributes[1]);
        String interfaceName = defaultInterfaceName;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: 
                case PORT: {
                    continue block4;
                }
                case INTERFACE: {
                    interfaceName = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        builder.addSocketBinding(name, interfaceName, port + portOffset);
    }

    private void parseInterfaces(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERFACE: {
                    this.parseInterface(reader, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseInterface(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.NAME});
        String name = attributes[0];
        Element element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        if (element == null) {
            throw ParseUtils.unexpectedEndElement((XMLStreamReader)reader);
        }
        switch (element) {
            case INET_ADDRESS: {
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.inetAddress(name, ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (Enum)Attribute.VALUE)));
                break;
            }
            case LINK_LOCAL: {
                ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.linkLocalAddress(name));
                break;
            }
            case GLOBAL: {
                ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.globalAddress(name));
                break;
            }
            case LOOPBACK: {
                ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.loopback(name));
                break;
            }
            case NON_LOOPBACK: {
                ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.nonLoopback(name));
                break;
            }
            case SITE_LOCAL: {
                ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.siteLocal(name));
                break;
            }
            case MATCH_INTERFACE: {
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.matchInterface(name, ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (Enum)Attribute.VALUE)));
                break;
            }
            case MATCH_ADDRESS: {
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.matchAddress(name, ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (Enum)Attribute.VALUE)));
                break;
            }
            case MATCH_HOST: {
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.matchHost(name, ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (Enum)Attribute.VALUE)));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseSecurity(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SECURITY_REALMS: {
                    this.parseSecurityRealms(reader, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSecurityRealms(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SECURITY_REALM: {
                    this.parseSecurityRealm(reader, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSecurityRealm(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        String name = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.NAME})[0];
        SecurityDomain.Builder domainBuilder = SecurityDomain.builder();
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        boolean hasTrustStore = false;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case FILESYSTEM_REALM: {
                    this.parseFileSystemRealm(reader, domainBuilder);
                    continue block12;
                }
                case KERBEROS_REALM: {
                    this.parseKerberosRealm(reader, domainBuilder);
                    continue block12;
                }
                case LDAP_REALM: {
                    this.parseLdapRealm(reader, domainBuilder);
                    continue block12;
                }
                case LOCAL_REALM: {
                    this.parseLocalRealm(reader, domainBuilder);
                    continue block12;
                }
                case PROPERTIES_REALM: {
                    this.parsePropertiesRealm(reader, domainBuilder);
                    continue block12;
                }
                case SERVER_IDENTITIES: {
                    this.parseServerIdentitities(reader, sslContextBuilder);
                    continue block12;
                }
                case TOKEN_REALM: {
                    this.parseTokenRealm(reader, domainBuilder);
                    continue block12;
                }
                case TRUSTSTORE_REALM: {
                    this.parseTrustStoreRealm(reader, sslContextBuilder);
                    hasTrustStore = true;
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        domainBuilder.setPermissionMapper((principal, roles) -> PermissionVerifier.from((Permission)new LoginPermission()));
        SecurityDomain securityDomain = domainBuilder.build();
        builder.addSecurityRealm(name, securityDomain);
        sslContextBuilder.setWrap(false);
        try {
            builder.addSSLContext(name, (SSLContext)sslContextBuilder.build().create());
        }
        catch (GeneralSecurityException e) {
            throw new CacheConfigurationException((Exception)e);
        }
    }

    private void parseFileSystemRealm(XMLExtendedStreamReader reader, SecurityDomain.Builder domainBuilder) throws XMLStreamException {
        String name = "filesystem";
        String path = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.PATH})[0];
        String relativeTo = (String)reader.getProperty("infinispan.server.data.path");
        boolean encoded = true;
        int levels = 0;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                case ENCODED: {
                    encoded = Boolean.parseBoolean(value);
                    continue block7;
                }
                case LEVELS: {
                    levels = Integer.parseInt(value);
                    continue block7;
                }
                case PATH: {
                    continue block7;
                }
                case RELATIVE_TO: {
                    relativeTo = ParseUtils.requireAttributeProperty((XMLStreamReader)reader, (int)i);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        FileSystemSecurityRealm fileSystemSecurityRealm = new FileSystemSecurityRealm(new File(ParseUtils.resolvePath((String)path, (String)relativeTo)).toPath(), NameRewriter.IDENTITY_REWRITER, levels, encoded);
        domainBuilder.addRealm(name, (SecurityRealm)fileSystemSecurityRealm).build();
    }

    private void parseTokenRealm(XMLExtendedStreamReader reader, SecurityDomain.Builder domainBuilder) throws XMLStreamException {
        String name = "token";
        TokenSecurityRealm.Builder tokenRealmBuilder = TokenSecurityRealm.builder();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block8;
                }
                case PRINCIPAL_CLAIM: {
                    tokenRealmBuilder.principalClaimName(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case JWT: {
                    this.parseJWT(reader, tokenRealmBuilder);
                    continue block9;
                }
                case OAUTH2_INTROSPECTION: {
                    this.parseOauth2Introspection(reader, tokenRealmBuilder);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        domainBuilder.addRealm(name, (SecurityRealm)tokenRealmBuilder.build()).build();
    }

    private void parseJWT(XMLExtendedStreamReader reader, TokenSecurityRealm.Builder tokenRealmBuilder) throws XMLStreamException {
        JwtValidator.Builder builder = JwtValidator.builder();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ISSUER: {
                    builder.issuer(reader.getListAttributeValue(i));
                    continue block5;
                }
                case AUDIENCE: {
                    builder.audience(reader.getListAttributeValue(i));
                    continue block5;
                }
                case PUBLIC_KEY: {
                    builder.publicKey(value.getBytes(StandardCharsets.UTF_8));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        tokenRealmBuilder.validator((TokenValidator)builder.build());
    }

    private void parseOauth2Introspection(XMLExtendedStreamReader reader, TokenSecurityRealm.Builder tokenRealmBuilder) throws XMLStreamException {
        OAuth2IntrospectValidator.Builder builder = OAuth2IntrospectValidator.builder();
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLIENT_ID: {
                    builder.clientId(value);
                    continue block9;
                }
                case CLIENT_SECRET: {
                    builder.clientSecret(value);
                    continue block9;
                }
                case INTROSPECTION_URL: {
                    try {
                        builder.tokenIntrospectionUrl(new URL(value));
                        continue block9;
                    }
                    catch (MalformedURLException e) {
                        throw new XMLStreamException(e);
                    }
                }
                case CLIENT_SSL_CONTEXT: {
                    continue block9;
                }
                case HOST_NAME_VERIFICATION_POLICY: {
                    builder.useSslHostnameVerifier(HostnameVerificationPolicy.valueOf(value).getVerifier());
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        tokenRealmBuilder.validator((TokenValidator)builder.build());
    }

    private void parseKerberosRealm(XMLExtendedStreamReader reader, SecurityDomain.Builder domainBuilder) throws XMLStreamException {
        String keyTab = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.KEYTAB})[0];
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        domainBuilder.addRealm("kerberos", (SecurityRealm)new KerberosSecurityRealm(new File(keyTab))).build();
    }

    private void parseLdapRealm(XMLExtendedStreamReader reader, SecurityDomain.Builder domainBuilder) throws XMLStreamException {
        String name = "ldap";
        SimpleDirContextFactoryBuilder dirContextBuilder = SimpleDirContextFactoryBuilder.builder();
        LdapSecurityRealmBuilder ldapRealmBuilder = LdapSecurityRealmBuilder.builder();
        LdapSecurityRealmBuilder.IdentityMappingBuilder identityMappingBuilder = ldapRealmBuilder.identityMapping();
        block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block13;
                }
                case URL: {
                    dirContextBuilder.setProviderUrl(value);
                    continue block13;
                }
                case PRINCIPAL: {
                    dirContextBuilder.setSecurityPrincipal(value);
                    continue block13;
                }
                case CREDENTIAL: {
                    dirContextBuilder.setSecurityCredential(value);
                    continue block13;
                }
                case DIRECT_VERIFICATION: {
                    ldapRealmBuilder.addDirectEvidenceVerification(Boolean.parseBoolean(value));
                    continue block13;
                }
                case PAGE_SIZE: {
                    ldapRealmBuilder.setPageSize(Integer.parseInt(value));
                    continue block13;
                }
                case SEARCH_DN: {
                    identityMappingBuilder.setSearchDn(value);
                    continue block13;
                }
                case RDN_IDENTIFIER: {
                    identityMappingBuilder.setRdnIdentifier(value);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case IDENTITY_MAPPING: {
                    this.parseLdapIdentityMapping(reader, ldapRealmBuilder, identityMappingBuilder);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        identityMappingBuilder.build();
        DirContextFactory dirContextFactory = dirContextBuilder.build();
        ldapRealmBuilder.setDirContextSupplier(() -> dirContextFactory.obtainDirContext(DirContextFactory.ReferralMode.FOLLOW));
        domainBuilder.addRealm(name, (SecurityRealm)ldapRealmBuilder.build()).build();
        if (domainBuilder.getDefaultRealmName() == null) {
            domainBuilder.setDefaultRealmName(name);
        }
    }

    private void parseLdapIdentityMapping(XMLExtendedStreamReader reader, LdapSecurityRealmBuilder ldapRealmBuilder, LdapSecurityRealmBuilder.IdentityMappingBuilder identityMappingBuilder) throws XMLStreamException {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SEARCH_DN: {
                    identityMappingBuilder.setSearchDn(value);
                    continue block8;
                }
                case RDN_IDENTIFIER: {
                    identityMappingBuilder.setRdnIdentifier(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ATTRIBUTE_MAPPING: {
                    this.parseLdapAttributeMapping(reader, ldapRealmBuilder);
                    continue block9;
                }
                case USER_PASSWORD_MAPPER: {
                    this.parseLdapUserPasswordMapper(reader, ldapRealmBuilder);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseLdapUserPasswordMapper(XMLExtendedStreamReader reader, LdapSecurityRealmBuilder ldapRealmBuilder) throws XMLStreamException {
        LdapSecurityRealmBuilder.UserPasswordCredentialLoaderBuilder b = ldapRealmBuilder.userPasswordCredentialLoader();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FROM: {
                    b.setUserPasswordAttribute(value);
                    continue block5;
                }
                case WRITABLE: {
                    if (!Boolean.parseBoolean(value)) continue block5;
                    b.enablePersistence();
                    continue block5;
                }
                case VERIFIABLE: {
                    if (Boolean.parseBoolean(value)) continue block5;
                    b.disableVerification();
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        b.build();
    }

    private void parseLdapAttributeMapping(XMLExtendedStreamReader reader, LdapSecurityRealmBuilder ldapRealmBuilder) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ATTRIBUTE: {
                    this.parseLdapAttribute(reader, ldapRealmBuilder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseLdapAttribute(XMLExtendedStreamReader reader, LdapSecurityRealmBuilder ldapRealmBuilder) throws XMLStreamException {
        String filter = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.FILTER})[0];
        AttributeMapping.Builder attributeMappingBuilder = AttributeMapping.fromFilter((String)filter);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FROM: {
                    attributeMappingBuilder.from(value);
                    continue block6;
                }
                case TO: {
                    attributeMappingBuilder.to(value);
                    continue block6;
                }
                case FILTER: {
                    continue block6;
                }
                case FILTER_DN: {
                    attributeMappingBuilder.searchDn(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ldapRealmBuilder.identityMapping().map(new AttributeMapping[]{attributeMappingBuilder.build()});
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseLocalRealm(XMLExtendedStreamReader reader, SecurityDomain.Builder domainBuilder) throws XMLStreamException {
        String name = "local";
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        if (domainBuilder.getDefaultRealmName() == null) {
            domainBuilder.setDefaultRealmName(name);
        }
    }

    private void parsePropertiesRealm(XMLExtendedStreamReader reader, SecurityDomain.Builder domainBuilder) throws XMLStreamException {
        int i;
        String relativeTo;
        String path;
        String name = "properties";
        File usersFile = null;
        File groupsFile = null;
        boolean plainText = false;
        String realmName = name;
        String groupsAttribute = "groups";
        block13: for (int i2 = 0; i2 < reader.getAttributeCount(); ++i2) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i2);
            String value = reader.getAttributeValue(i2);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i2));
            switch (attribute) {
                case GROUPS_ATTRIBUTE: {
                    groupsAttribute = value;
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i2);
                }
            }
        }
        Element element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        if (element == Element.USER_PROPERTIES) {
            path = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.PATH})[0];
            relativeTo = (String)reader.getProperty("infinispan.server.config.path");
            block14: for (i = 0; i < reader.getAttributeCount(); ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case PATH: {
                        continue block14;
                    }
                    case RELATIVE_TO: {
                        relativeTo = ParseUtils.requireAttributeProperty((XMLStreamReader)reader, (int)i);
                        continue block14;
                    }
                    case DIGEST_REALM_NAME: {
                        realmName = value;
                        continue block14;
                    }
                    case PLAIN_TEXT: {
                        plainText = Boolean.parseBoolean(value);
                        continue block14;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                    }
                }
            }
            usersFile = new File(ParseUtils.resolvePath((String)path, (String)relativeTo));
            ParseUtils.requireNoContent((XMLStreamReader)reader);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element == Element.GROUP_PROPERTIES) {
            path = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.PATH})[0];
            relativeTo = (String)reader.getProperty("infinispan.server.config.path");
            block15: for (i = 0; i < reader.getAttributeCount(); ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case PATH: {
                        continue block15;
                    }
                    case RELATIVE_TO: {
                        relativeTo = ParseUtils.requireAttributeProperty((XMLStreamReader)reader, (int)i);
                        continue block15;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                    }
                }
            }
            groupsFile = new File(ParseUtils.resolvePath((String)path, (String)relativeTo));
            ParseUtils.requireNoContent((XMLStreamReader)reader);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        domainBuilder.addRealm(name, (SecurityRealm)new PropertiesSecurityRealm(usersFile, groupsFile, plainText, groupsAttribute, realmName)).build();
        if (domainBuilder.getDefaultRealmName() == null) {
            domainBuilder.setDefaultRealmName(name);
        }
    }

    private void parseServerIdentitities(XMLExtendedStreamReader reader, SSLContextBuilder sslContextBuilder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SSL: {
                    this.parseSSL(reader, sslContextBuilder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSSL(XMLExtendedStreamReader reader, SSLContextBuilder sslContextBuilder) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENGINE: {
                    this.parseSSLEngine(reader, sslContextBuilder);
                    continue block4;
                }
                case KEYSTORE: {
                    this.parseKeyStore(reader, sslContextBuilder);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSSLEngine(XMLExtendedStreamReader reader, SSLContextBuilder sslContextBuilder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED_PROTOCOLS: {
                    ProtocolSelector protocolSelector = ProtocolSelector.empty();
                    for (String protocol : reader.getListAttributeValue(i)) {
                        protocolSelector.add(protocol);
                    }
                    sslContextBuilder.setProtocolSelector(protocolSelector);
                    continue block4;
                }
                case ENABLED_CIPHERSUITES: {
                    sslContextBuilder.setCipherSuiteSelector(CipherSuiteSelector.fromString((String)reader.getAttributeValue(i)));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseKeyStore(XMLExtendedStreamReader reader, SSLContextBuilder sslContextBuilder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.PATH});
        String path = attributes[0];
        String relativeTo = (String)reader.getProperty("infinispan.server.config.path");
        String keyStoreProvider = null;
        char[] keyStorePassword = null;
        String keyAlias = null;
        char[] keyPassword = null;
        String generateSelfSignedHost = null;
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    continue block11;
                }
                case PROVIDER: {
                    keyStoreProvider = value;
                    continue block11;
                }
                case RELATIVE_TO: {
                    relativeTo = ParseUtils.requireAttributeProperty((XMLStreamReader)reader, (int)i);
                    continue block11;
                }
                case KEYSTORE_PASSWORD: {
                    keyStorePassword = value.toCharArray();
                    continue block11;
                }
                case ALIAS: {
                    keyAlias = value;
                    continue block11;
                }
                case KEY_PASSWORD: {
                    keyPassword = value.toCharArray();
                    continue block11;
                }
                case GENERATE_SELF_SIGNED_CERTIFICATE_HOST: {
                    generateSelfSignedHost = value;
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        String keyStoreFileName = ParseUtils.resolvePath((String)path, (String)relativeTo);
        try {
            if (!new File(keyStoreFileName).exists() && generateSelfSignedHost != null) {
                KeyStoreUtils.generateSelfSignedCertificate(keyStoreFileName, keyStoreProvider, keyStorePassword, keyPassword, keyAlias, generateSelfSignedHost);
            }
            KeyStore keyStore = KeyStoreUtil.loadKeyStore((Supplier)ProviderUtil.INSTALLED_PROVIDERS, (String)keyStoreProvider, (FileInputStream)new FileInputStream(keyStoreFileName), (String)keyStoreFileName, (char[])keyStorePassword);
            if (keyAlias != null) {
                keyStore = FilteringKeyStore.filteringKeyStore((KeyStore)keyStore, (Predicate)AliasFilter.fromString((String)keyAlias));
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, keyPassword != null ? keyPassword : keyStorePassword);
            for (KeyManager keyManager : kmf.getKeyManagers()) {
                if (!(keyManager instanceof X509ExtendedKeyManager)) continue;
                sslContextBuilder.setKeyManager((X509ExtendedKeyManager)keyManager);
                return;
            }
            throw Server.log.noDefaultKeyManager();
        }
        catch (Exception e) {
            throw new CacheConfigurationException(e);
        }
    }

    private void parseTrustStoreRealm(XMLExtendedStreamReader reader, SSLContextBuilder sslContextBuilder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.PATH});
        String path = attributes[0];
        String relativeTo = (String)reader.getProperty("infinispan.server.config.path");
        String keyStoreProvider = null;
        char[] keyStorePassword = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    continue block8;
                }
                case PROVIDER: {
                    keyStoreProvider = value;
                    continue block8;
                }
                case KEYSTORE_PASSWORD: {
                    keyStorePassword = value.toCharArray();
                    continue block8;
                }
                case RELATIVE_TO: {
                    relativeTo = ParseUtils.requireAttributeProperty((XMLStreamReader)reader, (int)i);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        String trustStoreFileName = ParseUtils.resolvePath((String)path, (String)relativeTo);
        try {
            KeyStore keyStore = KeyStoreUtil.loadKeyStore((Supplier)ProviderUtil.INSTALLED_PROVIDERS, keyStoreProvider, (FileInputStream)new FileInputStream(trustStoreFileName), (String)trustStoreFileName, keyStorePassword);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            for (TrustManager trustManager : tmf.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                sslContextBuilder.setTrustManager((X509TrustManager)trustManager);
                return;
            }
            throw Server.log.noDefaultKeyManager();
        }
        catch (Exception e) {
            throw new CacheConfigurationException(e);
        }
    }

    private void parseEndpoints(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ServerConfigurationBuilder builder) throws XMLStreamException {
        holder.pushScope(ENDPOINTS_SCOPE);
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.SOCKET_BINDING});
        builder.applySocketBinding(attributes[0], builder.endpoint());
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SOCKET_BINDING: {
                    continue block3;
                }
                default: {
                    ServerConfigurationParser.parseCommonConnectorAttributes(reader, i, builder, builder.endpoint());
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            reader.handleAny(holder);
        }
        holder.popScope();
    }

    public static void parseCommonConnectorAttributes(XMLExtendedStreamReader reader, int index, ServerConfigurationBuilder serverBuilder, ProtocolServerConfigurationBuilder<?, ?> builder) throws XMLStreamException {
        String value = reader.getAttributeValue(index);
        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case CACHE_CONTAINER: {
                break;
            }
            case IDLE_TIMEOUT: {
                builder.idleTimeout(Integer.parseInt(value));
                break;
            }
            case IO_THREADS: {
                builder.ioThreads(Integer.parseInt(value));
                break;
            }
            case RECEIVE_BUFFER_SIZE: {
                builder.recvBufSize(Integer.parseInt(value));
                break;
            }
            case REQUIRE_SSL_CLIENT_AUTH: {
                builder.ssl().requireClientAuth(Boolean.parseBoolean(value));
                break;
            }
            case SECURITY_REALM: {
                builder.ssl().enable().sslContext(serverBuilder.getSSLContext(value));
                break;
            }
            case SEND_BUFFER_SIZE: {
                builder.sendBufSize(Integer.parseInt(value));
                break;
            }
            case TCP_KEEPALIVE: {
                builder.tcpKeepAlive(Boolean.parseBoolean(value));
                break;
            }
            case TCP_NODELAY: {
                builder.tcpNoDelay(Boolean.parseBoolean(value));
                break;
            }
            case WORKER_THREADS: {
                builder.workerThreads(Integer.parseInt(value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)index);
            }
        }
    }
}

