/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.rest;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.rest.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfigurationParser;
import org.infinispan.server.configuration.rest.Attribute;
import org.infinispan.server.configuration.rest.Element;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.core.configuration.SslConfigurationBuilder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(root="rest-connector"), @Namespace(uri="urn:infinispan:server:*", root="rest-connector")})
public class RestServerConfigurationParser
implements ConfigurationParser {
    private static Log coreLog = LogFactory.getLog(ServerConfigurationParser.class);

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        if (!holder.inScope(ServerConfigurationParser.ENDPOINTS_SCOPE)) {
            throw coreLog.invalidScope(ServerConfigurationParser.ENDPOINTS_SCOPE, holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case REST_CONNECTOR: {
                ServerConfigurationBuilder serverBuilder = (ServerConfigurationBuilder)builder.module(ServerConfigurationBuilder.class);
                if (serverBuilder != null) {
                    this.parseRest(reader, serverBuilder);
                    break;
                }
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private void parseRest(XMLExtendedStreamReader reader, ServerConfigurationBuilder serverBuilder) throws XMLStreamException {
        RestServerConfigurationBuilder builder = serverBuilder.addConnector(RestServerConfigurationBuilder.class);
        boolean hasSocketBinding = false;
        block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONTEXT_PATH: {
                    builder.contextPath(value);
                    continue block14;
                }
                case EXTENDED_HEADERS: {
                    builder.extendedHeaders(ExtendedHeaders.valueOf((String)value));
                    continue block14;
                }
                case NAME: {
                    builder.name(value);
                    continue block14;
                }
                case MAX_CONTENT_LENGTH: {
                    builder.maxContentLength(Integer.parseInt(value));
                    continue block14;
                }
                case COMPRESSION_LEVEL: {
                    builder.compressionLevel(Integer.parseInt(value));
                    continue block14;
                }
                case IGNORED_CACHES: {
                    String[] values;
                    HashSet<String> ignoredCaches = new HashSet<String>();
                    for (String v : values = reader.getListAttributeValue(i)) {
                        ignoredCaches.add(v);
                    }
                    builder.ignoredCaches(ignoredCaches);
                    continue block14;
                }
                case SOCKET_BINDING: {
                    serverBuilder.applySocketBinding(value, (ProtocolServerConfigurationBuilder)builder);
                    hasSocketBinding = true;
                    continue block14;
                }
                default: {
                    ServerConfigurationParser.parseCommonConnectorAttributes(reader, i, serverBuilder, builder);
                }
            }
        }
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHENTICATION: {
                    this.parseAuthentication(reader, serverBuilder, builder.authentication().enable());
                    continue block16;
                }
                case ENCRYPTION: {
                    this.parseEncryption(reader, serverBuilder, builder.ssl().enable());
                    continue block16;
                }
                case CORS_RULES: {
                    this.parseCorsRules(reader, builder);
                    continue block16;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        if (!hasSocketBinding) {
            builder.startTransport(false);
        }
    }

    private void parseCorsRules(XMLExtendedStreamReader reader, RestServerConfigurationBuilder builder) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
        ArrayList<CorsConfig> rules = new ArrayList<CorsConfig>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CORS_RULE: {
                    rules.add(this.parseCorsRule(reader));
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        builder.addAll(rules);
    }

    private CorsConfig parseCorsRule(XMLExtendedStreamReader reader) throws XMLStreamException {
        CorsConfigBuilder builder;
        boolean allowCredentials = false;
        Optional<Long> maxAge = Optional.empty();
        Optional<String[]> allowedHeaders = Optional.empty();
        Optional<Object> allowedOrigins = Optional.empty();
        Optional<HttpMethod[]> allowedMethods = Optional.empty();
        Optional<Object> exposeHeaders = Optional.empty();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ALLOW_CREDENTIALS: {
                    allowCredentials = true;
                    continue block10;
                }
                case MAX_AGE_SECONDS: {
                    maxAge = Optional.of(Long.parseLong(value));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ALLOWED_HEADERS: {
                    allowedHeaders = Optional.of(reader.getElementText().split(","));
                    continue block11;
                }
                case ALLOWED_ORIGINS: {
                    allowedOrigins = Optional.of(reader.getElementText().split(","));
                    continue block11;
                }
                case ALLOWED_METHODS: {
                    allowedMethods = Optional.of((HttpMethod[])Arrays.stream(reader.getElementText().split(",")).map(HttpMethod::valueOf).toArray(HttpMethod[]::new));
                    continue block11;
                }
                case EXPOSE_HEADERS: {
                    exposeHeaders = Optional.of(reader.getElementText().split(","));
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        CorsConfigBuilder corsConfigBuilder = builder = allowedOrigins.isPresent() ? CorsConfigBuilder.forOrigins((String[])((String[])allowedOrigins.get())) : CorsConfigBuilder.forAnyOrigin();
        if (allowCredentials) {
            builder.allowCredentials();
        }
        maxAge.ifPresent(a -> builder.maxAge(a.longValue()));
        allowedHeaders.ifPresent(h -> builder.allowedRequestHeaders(h));
        allowedMethods.ifPresent(m -> builder.allowedRequestMethods(m));
        exposeHeaders.ifPresent(h -> builder.exposeHeaders(h));
        return builder.build();
    }

    private void parseAuthentication(XMLExtendedStreamReader reader, ServerConfigurationBuilder serverBuilder, AuthenticationConfigurationBuilder builder) throws XMLStreamException {
        String securityRealm = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{org.infinispan.server.configuration.hotrod.Attribute.SECURITY_REALM})[0];
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SECURITY_REALM: {
                    continue block4;
                }
                case MECHANISMS: {
                    builder.addMechanisms(reader.getListAttributeValue(i));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        builder.authenticator(serverBuilder.getHTTPAuthenticationProvider(securityRealm));
    }

    private void parseEncryption(XMLExtendedStreamReader reader, ServerConfigurationBuilder serverBuilder, SslConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            switch (attribute) {
                case REQUIRE_SSL_CLIENT_AUTH: {
                    builder.requireClientAuth(Boolean.parseBoolean(value));
                    continue block7;
                }
                case SECURITY_REALM: {
                    builder.sslContext(serverBuilder.getSSLContext(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        boolean skipTagCheckAtTheEnd = reader.hasNext();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SNI: {
                    this.parseSni(reader, builder);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        if (!skipTagCheckAtTheEnd) {
            ParseUtils.requireNoContent((XMLStreamReader)reader);
        }
    }

    private void parseSni(XMLExtendedStreamReader reader, SslConfigurationBuilder builder) {
    }
}

