/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import io.netty.channel.ChannelHandlerContext;
import java.security.Provider;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.server.security.HttpServerRequestAdapter;
import org.infinispan.server.security.RolePrincipal;
import org.wildfly.security.WildFlyElytronProvider;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.http.HttpAuthenticationFactory;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.util.SecurityProviderServerMechanismFactory;
import org.wildfly.security.http.util.SetMechanismInformationMechanismFactory;

public class ElytronHTTPAuthenticator
implements Authenticator {
    private final HttpAuthenticationFactory factory;
    private Executor executor;
    private RestServerConfiguration configuration;

    public ElytronHTTPAuthenticator(String name, SecurityDomain domain) {
        HttpAuthenticationFactory.Builder httpBuilder = HttpAuthenticationFactory.builder();
        httpBuilder.setSecurityDomain(domain);
        WildFlyElytronProvider elytronProvider = new WildFlyElytronProvider();
        SecurityProviderServerMechanismFactory httpServerFactory = new SecurityProviderServerMechanismFactory(() -> ElytronHTTPAuthenticator.lambda$new$0((Provider)elytronProvider));
        httpServerFactory = new SetMechanismInformationMechanismFactory((HttpServerAuthenticationMechanismFactory)httpServerFactory);
        httpBuilder.setFactory((HttpServerAuthenticationMechanismFactory)httpServerFactory);
        MechanismConfiguration.Builder mechConfigurationBuilder = MechanismConfiguration.builder();
        MechanismRealmConfiguration.Builder mechRealmBuilder = MechanismRealmConfiguration.builder();
        mechRealmBuilder.setRealmName(name);
        mechConfigurationBuilder.addMechanismRealm(mechRealmBuilder.build());
        httpBuilder.setMechanismConfigurationSelector(MechanismConfigurationSelector.constantSelector((MechanismConfiguration)mechConfigurationBuilder.build()));
        this.factory = httpBuilder.build();
    }

    public CompletionStage<RestResponse> challenge(RestRequest request, ChannelHandlerContext ctx) {
        HttpServerRequestAdapter requestAdapter = new HttpServerRequestAdapter(request, ctx);
        return CompletableFuture.supplyAsync(() -> {
            try {
                String authorizationHeader = request.getAuthorizationHeader();
                if (authorizationHeader == null) {
                    for (String name : this.configuration.authentication().mechanisms()) {
                        HttpServerAuthenticationMechanism mechanism = (HttpServerAuthenticationMechanism)this.factory.createMechanism(name);
                        mechanism.evaluateRequest((HttpServerRequest)requestAdapter);
                    }
                    return requestAdapter.getResponse();
                }
                String mechName = authorizationHeader.substring(0, authorizationHeader.indexOf(32)).toUpperCase();
                HttpServerAuthenticationMechanism mechanism = (HttpServerAuthenticationMechanism)this.factory.createMechanism(mechName);
                mechanism.evaluateRequest((HttpServerRequest)requestAdapter);
                SecurityIdentity securityIdentity = (SecurityIdentity)mechanism.getNegotiatedProperty("wildfly.http.security-identity");
                if (securityIdentity != null) {
                    Subject subject = new Subject();
                    subject.getPrincipals().add(securityIdentity.getPrincipal());
                    securityIdentity.getRoles().forEach(r -> subject.getPrincipals().add(new RolePrincipal((String)r)));
                    request.setSubject(subject);
                }
                return requestAdapter.getResponse();
            }
            catch (HttpAuthenticationException e) {
                throw new RestResponseException((Throwable)e);
            }
        }, this.executor);
    }

    public void init(RestServer restServer) {
        this.configuration = (RestServerConfiguration)restServer.getConfiguration();
        this.executor = restServer.getExecutor();
        for (String name : this.configuration.authentication().mechanisms()) {
            try {
                this.factory.createMechanism(name);
            }
            catch (HttpAuthenticationException e) {
                throw new CacheConfigurationException("Could not create HTTP authentication mechanism " + name);
            }
        }
    }

    private static /* synthetic */ Provider[] lambda$new$0(Provider elytronProvider) {
        return new Provider[]{elytronProvider};
    }
}

