/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.sasl.SaslAuthenticationFactory;
import org.wildfly.security.sasl.util.AggregateSaslServerFactory;
import org.wildfly.security.sasl.util.PropertiesSaslServerFactory;
import org.wildfly.security.sasl.util.ProtocolSaslServerFactory;
import org.wildfly.security.sasl.util.SaslFactories;
import org.wildfly.security.sasl.util.ServerNameSaslServerFactory;

public class ElytronSASLAuthenticationProvider
implements ServerAuthenticationProvider {
    private final SaslAuthenticationFactory saslAuthenticationFactory;

    public ElytronSASLAuthenticationProvider(String name, SecurityDomain domain) {
        SaslAuthenticationFactory.Builder builder = SaslAuthenticationFactory.builder();
        AggregateSaslServerFactory factory = new AggregateSaslServerFactory(new SaslServerFactory[]{SaslFactories.getProviderSaslServerFactory()});
        builder.setFactory((SaslServerFactory)factory);
        builder.setSecurityDomain(domain);
        MechanismConfiguration.Builder mechConfigurationBuilder = MechanismConfiguration.builder();
        MechanismRealmConfiguration.Builder mechRealmBuilder = MechanismRealmConfiguration.builder();
        mechRealmBuilder.setRealmName(name);
        mechConfigurationBuilder.addMechanismRealm(mechRealmBuilder.build());
        builder.setMechanismConfigurationSelector(MechanismConfigurationSelector.constantSelector((MechanismConfiguration)mechConfigurationBuilder.build()));
        this.saslAuthenticationFactory = builder.build();
    }

    public SaslServer createSaslServer(String mechanism, List<Principal> principals, String protocol, String serverName, Map<String, String> props) throws SaslException {
        return (SaslServer)this.saslAuthenticationFactory.createMechanism(mechanism, factory -> {
            factory = new ServerNameSaslServerFactory(factory, serverName);
            factory = new ProtocolSaslServerFactory(factory, protocol);
            factory = props != null ? new PropertiesSaslServerFactory(factory, props) : factory;
            return factory;
        });
    }
}

