/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security.realm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import org.infinispan.server.Server;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.LegacyPropertiesSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public class PropertiesSecurityRealm
implements SecurityRealm {
    private final File usersFile;
    private final File groupsFile;
    private final boolean plainText;
    private final String groupsAttribute;
    private final String realmName;
    LegacyPropertiesSecurityRealm delegate;

    public PropertiesSecurityRealm(File usersFile, File groupsFile, boolean plainText, String groupsAttribute, String realmName) {
        this.usersFile = usersFile;
        this.groupsFile = groupsFile;
        this.plainText = plainText;
        this.groupsAttribute = groupsAttribute;
        this.realmName = realmName;
        this.load();
    }

    private void load() {
        try (FileInputStream usersInputStream = new FileInputStream(this.usersFile);
             FileInputStream groupsInputStream = this.groupsFile != null ? new FileInputStream(this.groupsFile) : null;){
            this.delegate = LegacyPropertiesSecurityRealm.builder().setUsersStream((InputStream)usersInputStream).setGroupsStream((InputStream)groupsInputStream).setPlainText(this.plainText).setGroupsAttribute(this.groupsAttribute).setDefaultRealm(this.realmName).build();
        }
        catch (IOException e) {
            throw Server.log.unableToLoadRealmPropertyFiles(e);
        }
    }

    void reload() {
        try (FileInputStream usersInputStream = new FileInputStream(this.usersFile);
             FileInputStream groupsInputStream = this.groupsFile != null ? new FileInputStream(this.groupsFile) : null;){
            this.delegate.load((InputStream)usersInputStream, (InputStream)groupsInputStream);
        }
        catch (IOException e) {
            throw Server.log.unableToLoadRealmPropertyFiles(e);
        }
    }

    long getLoadTime() {
        return this.delegate.getLoadTime();
    }

    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        return this.delegate.getRealmIdentity(principal);
    }

    public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
        return this.delegate.getRealmIdentity(evidence);
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return this.delegate.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return this.delegate.getEvidenceVerifySupport(evidenceType, algorithmName);
    }
}

