/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.InterfacesConfiguration;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.SocketBindingConfiguration;
import org.infinispan.server.configuration.SocketBindingsConfiguration;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.network.SocketBinding;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;

@BuiltBy(value=ServerConfigurationBuilder.class)
public class ServerConfiguration
implements ConfigurationInfo {
    private final InterfacesConfiguration interfaces;
    private final SocketBindingsConfiguration socketBindings;
    private final List<ProtocolServerConfiguration> connectors;
    private final SinglePortRouterConfiguration endpoint;
    private final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.SERVER.toString(), true, false);
    private final List<ConfigurationInfo> elements = new ArrayList<ConfigurationInfo>();

    ServerConfiguration(InterfacesConfiguration interfaces, SocketBindingsConfiguration socketBindings, SecurityConfiguration security, List<ProtocolServerConfiguration> connectors, SinglePortRouterConfiguration endpoint) {
        this.interfaces = interfaces;
        this.socketBindings = socketBindings;
        this.connectors = connectors;
        this.endpoint = endpoint;
        this.elements.add(interfaces);
        this.elements.add(socketBindings);
        this.elements.add(security);
    }

    public ElementDefinition getElementDefinition() {
        return this.ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.elements;
    }

    public Map<String, NetworkAddress> networkInterfaces() {
        return this.interfaces.getAddressMap();
    }

    public Map<String, SocketBinding> socketBindings() {
        return this.socketBindings.socketBindings().stream().collect(Collectors.toMap(SocketBindingConfiguration::name, SocketBindingConfiguration::getSocketBinding));
    }

    public List<ProtocolServerConfiguration> connectors() {
        return this.connectors;
    }

    public SinglePortRouterConfiguration endpoint() {
        return this.endpoint;
    }
}

