/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.hotrod;

import java.util.EnumSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfigurationParser;
import org.infinispan.server.configuration.hotrod.Attribute;
import org.infinispan.server.configuration.hotrod.Element;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.core.configuration.SslConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.security.ServerSecurityRealm;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(root="hotrod-connector"), @Namespace(uri="urn:infinispan:server:*", root="hotrod-connector")})
public class HotRodServerConfigurationParser
implements ConfigurationParser {
    private static Log coreLog = LogFactory.getLog(ServerConfigurationParser.class);

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        if (!holder.inScope(ServerConfigurationParser.ENDPOINTS_SCOPE)) {
            throw coreLog.invalidScope(ServerConfigurationParser.ENDPOINTS_SCOPE, holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case HOTROD_CONNECTOR: {
                ServerConfigurationBuilder serverBuilder = (ServerConfigurationBuilder)builder.module(ServerConfigurationBuilder.class);
                if (serverBuilder == null) break;
                this.parseHotRodConnector(reader, holder, serverBuilder, serverBuilder.addConnector(HotRodServerConfigurationBuilder.class));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private void parseHotRodConnector(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ServerConfigurationBuilder serverBuilder, HotRodServerConfigurationBuilder builder) throws XMLStreamException {
        boolean dedicatedSocketBinding = false;
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case EXTERNAL_HOST: {
                    builder.proxyHost(value);
                    continue block11;
                }
                case EXTERNAL_PORT: {
                    builder.proxyPort(Integer.parseInt(value));
                    continue block11;
                }
                case NAME: {
                    builder.name(value);
                    continue block11;
                }
                case SOCKET_BINDING: {
                    serverBuilder.applySocketBinding(value, (ProtocolServerConfigurationBuilder)builder);
                    builder.startTransport(true);
                    dedicatedSocketBinding = true;
                    continue block11;
                }
                default: {
                    ServerConfigurationParser.parseCommonConnectorAttributes(reader, i, serverBuilder, builder);
                }
            }
        }
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TOPOLOGY_STATE_TRANSFER: {
                    this.parseTopologyStateTransfer(reader, builder);
                    continue block12;
                }
                case AUTHENTICATION: {
                    this.parseAuthentication(reader, serverBuilder, builder.authentication().enable());
                    continue block12;
                }
                case ENCRYPTION: {
                    if (!dedicatedSocketBinding) {
                        throw Server.log.cannotConfigureProtocolEncryptionUnderSinglePort();
                    }
                    this.parseEncryption(reader, serverBuilder, builder.ssl().enable());
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseEncryption(XMLExtendedStreamReader reader, ServerConfigurationBuilder serverBuilder, SslConfigurationBuilder builder) throws XMLStreamException {
        String securityRealm = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.SECURITY_REALM})[0];
        builder.sslContext(serverBuilder.getSSLContext(securityRealm));
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REQUIRE_SSL_CLIENT_AUTH: {
                    builder.requireClientAuth(Boolean.parseBoolean(value));
                    continue block7;
                }
                case SECURITY_REALM: {
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SNI: {
                    this.parseSni(reader, serverBuilder, builder);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSni(XMLExtendedStreamReader reader, ServerConfigurationBuilder serverBuilder, SslConfigurationBuilder builder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST_NAME: {
                    builder.sniHostName(value);
                    continue block4;
                }
                case SECURITY_REALM: {
                    builder.sslContext(serverBuilder.getSSLContext(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseAuthentication(XMLExtendedStreamReader reader, ServerConfigurationBuilder serverBuilder, AuthenticationConfigurationBuilder builder) throws XMLStreamException {
        ServerSecurityRealm securityRealm = serverBuilder.endpoint().securityRealm();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SECURITY_REALM: {
                    securityRealm = serverBuilder.getSecurityRealm(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SASL: {
                    this.parseSasl(reader, builder);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        if (securityRealm == null) {
            throw Server.log.authenticationWithoutSecurityRealm();
        }
        builder.serverAuthenticationProvider(securityRealm.getSASLAuthenticationProvider());
    }

    private void parseSasl(XMLExtendedStreamReader reader, AuthenticationConfigurationBuilder builder) throws XMLStreamException {
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SERVER_CONTEXT_NAME: {
                    continue block11;
                }
                case SERVER_NAME: {
                    builder.serverName(value);
                    continue block11;
                }
                case MECHANISMS: {
                    for (String mech : reader.getListAttributeValue(i)) {
                        builder.addAllowedMech(mech);
                    }
                    continue block11;
                }
                case QOP: {
                    builder.addMechProperty("javax.security.sasl.qop", value);
                    continue block11;
                }
                case STRENGTH: {
                    builder.addMechProperty("javax.security.sasl.strength", value);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case POLICY: {
                    if (visited.contains((Object)element)) {
                        throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
                    }
                    visited.add(element);
                    this.parsePolicy(reader, builder);
                    continue block13;
                }
                case PROPERTY: {
                    builder.addMechProperty(ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (Enum)Attribute.NAME), reader.getElementText());
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    void parsePolicy(XMLExtendedStreamReader reader, AuthenticationConfigurationBuilder builder) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)0);
        }
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
            visited.add(element);
            String value = ParseUtils.readStringAttributeElement((XMLStreamReader)reader, (String)Attribute.VALUE.name());
            switch (element) {
                case FORWARD_SECRECY: {
                    builder.addMechProperty("javax.security.sasl.policy.forward", value);
                    continue block8;
                }
                case NO_ACTIVE: {
                    builder.addMechProperty("javax.security.sasl.policy.noactive", value);
                    continue block8;
                }
                case NO_ANONYMOUS: {
                    builder.addMechProperty("javax.security.sasl.policy.noanonymous", value);
                    continue block8;
                }
                case NO_DICTIONARY: {
                    builder.addMechProperty("javax.security.sasl.policy.nodictionary", value);
                    continue block8;
                }
                case NO_PLAIN_TEXT: {
                    builder.addMechProperty("javax.security.sasl.policy.noplaintext", value);
                    continue block8;
                }
                case PASS_CREDENTIALS: {
                    builder.addMechProperty("javax.security.sasl.policy.credentials", value);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseTopologyStateTransfer(XMLExtendedStreamReader reader, HotRodServerConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case LOCK_TIMEOUT: {
                    builder.topologyLockTimeout(Long.parseLong(value));
                    continue block6;
                }
                case AWAIT_INITIAL_RETRIEVAL: {
                    builder.topologyAwaitInitialTransfer(Boolean.parseBoolean(value));
                    continue block6;
                }
                case REPLICATION_TIMEOUT: {
                    builder.topologyReplTimeout(Long.parseLong(value));
                    continue block6;
                }
                case LAZY_RETRIEVAL: {
                    builder.topologyStateTransfer(Boolean.parseBoolean(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }
}

