/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.function.Supplier;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.TrustStoreRealmConfiguration;
import org.wildfly.security.keystore.KeyStoreUtil;
import org.wildfly.security.provider.util.ProviderUtil;
import org.wildfly.security.ssl.SSLContextBuilder;

public class TrustStoreRealmConfigurationBuilder
implements Builder<TrustStoreRealmConfiguration> {
    private final AttributeSet attributes;
    private final RealmConfigurationBuilder securityRealmBuilder;
    private TrustManagerFactory trustManagerFactory;

    TrustStoreRealmConfigurationBuilder(RealmConfigurationBuilder securityRealmBuilder) {
        this.securityRealmBuilder = securityRealmBuilder;
        this.attributes = TrustStoreRealmConfiguration.attributeDefinitionSet();
    }

    public TrustStoreRealmConfigurationBuilder path(String path) {
        this.attributes.attribute(TrustStoreRealmConfiguration.PATH).set((Object)path);
        return this;
    }

    public TrustStoreRealmConfigurationBuilder provider(String provider) {
        this.attributes.attribute(TrustStoreRealmConfiguration.PROVIDER).set((Object)provider);
        return this;
    }

    public TrustStoreRealmConfigurationBuilder keyStorePassword(char[] keyStorePassword) {
        this.attributes.attribute(TrustStoreRealmConfiguration.KEYSTORE_PASSWORD).set((Object)keyStorePassword);
        return this;
    }

    public TrustStoreRealmConfigurationBuilder relativeTo(String relativeTo) {
        this.attributes.attribute(TrustStoreRealmConfiguration.RELATIVE_TO).set((Object)relativeTo);
        return this;
    }

    public void validate() {
    }

    public TrustStoreRealmConfigurationBuilder build() {
        if (this.trustManagerFactory == null) {
            SSLContextBuilder sslContextBuilder = this.securityRealmBuilder.sslContextBuilder();
            if (sslContextBuilder == null) {
                throw Server.log.trustStoreWithoutServerIdentity();
            }
            String path = (String)this.attributes.attribute(TrustStoreRealmConfiguration.PATH).get();
            String relativeTo = (String)this.attributes.attribute(TrustStoreRealmConfiguration.RELATIVE_TO).get();
            String trustStoreFileName = ParseUtils.resolvePath((String)path, (String)relativeTo);
            String keyStoreProvider = (String)this.attributes.attribute(TrustStoreRealmConfiguration.PROVIDER).get();
            char[] keyStorePassword = (char[])this.attributes.attribute(TrustStoreRealmConfiguration.KEYSTORE_PASSWORD).get();
            try {
                KeyStore keyStore = KeyStoreUtil.loadKeyStore((Supplier)ProviderUtil.INSTALLED_PROVIDERS, (String)keyStoreProvider, (FileInputStream)new FileInputStream(trustStoreFileName), (String)trustStoreFileName, (char[])keyStorePassword);
                this.trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                this.trustManagerFactory.init(keyStore);
                for (TrustManager trustManager : this.trustManagerFactory.getTrustManagers()) {
                    if (!(trustManager instanceof X509TrustManager)) continue;
                    sslContextBuilder.setTrustManager((X509TrustManager)trustManager);
                }
            }
            catch (Exception e) {
                throw new CacheConfigurationException(e);
            }
        }
        return this;
    }

    public TrustStoreRealmConfiguration create() {
        return new TrustStoreRealmConfiguration(this.attributes.protect());
    }

    public TrustStoreRealmConfigurationBuilder read(TrustStoreRealmConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

