/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.security.realm.KerberosSecurityRealm;

public class KerberosRealmConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> KEYTAB_PATH = AttributeDefinition.builder((String)"keytabPath", null, String.class).build();
    static final AttributeDefinition<String> RELATIVE_TO = AttributeDefinition.builder((String)"relativeTo", null, String.class).build();
    private static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.KERBEROS_REALM.toString());
    private final AttributeSet attributes;
    private final KerberosSecurityRealm securityRealm;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(KerberosRealmConfiguration.class, new AttributeDefinition[]{KEYTAB_PATH, RELATIVE_TO});
    }

    KerberosRealmConfiguration(AttributeSet attributes, KerberosSecurityRealm securityRealm) {
        this.attributes = attributes.checkProtection();
        this.securityRealm = securityRealm;
    }

    public KerberosSecurityRealm getSecurityRealm() {
        return this.securityRealm;
    }

    public String keyTabPath() {
        return (String)this.attributes.attribute(KEYTAB_PATH).get();
    }

    public String relativeTo() {
        return (String)this.attributes.attribute(RELATIVE_TO).get();
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }
}

