/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.rest;

import javax.net.ssl.SSLContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.rest.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.rest.configuration.CorsConfigurationBuilder;
import org.infinispan.rest.configuration.CorsRuleConfigurationBuilder;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfigurationParser;
import org.infinispan.server.configuration.rest.Attribute;
import org.infinispan.server.configuration.rest.Element;
import org.infinispan.server.core.configuration.EncryptionConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.core.configuration.SniConfigurationBuilder;
import org.infinispan.server.security.ServerSecurityRealm;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(root="rest-connector"), @Namespace(uri="urn:infinispan:server:*", root="rest-connector")})
public class RestServerConfigurationParser
implements ConfigurationParser {
    private static Log coreLog = LogFactory.getLog(ServerConfigurationParser.class);

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        if (!holder.inScope(ServerConfigurationParser.ENDPOINTS_SCOPE)) {
            throw coreLog.invalidScope(ServerConfigurationParser.ENDPOINTS_SCOPE, holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case REST_CONNECTOR: {
                ServerConfigurationBuilder serverBuilder = (ServerConfigurationBuilder)builder.module(ServerConfigurationBuilder.class);
                if (serverBuilder != null) {
                    this.parseRest(reader, serverBuilder);
                    break;
                }
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private void parseRest(XMLExtendedStreamReader reader, ServerConfigurationBuilder serverBuilder) throws XMLStreamException {
        boolean dedicatedSocketBinding = false;
        RestServerConfigurationBuilder builder = serverBuilder.endpoints().addConnector(RestServerConfigurationBuilder.class);
        block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONTEXT_PATH: {
                    builder.contextPath(value);
                    continue block13;
                }
                case EXTENDED_HEADERS: {
                    builder.extendedHeaders(ExtendedHeaders.valueOf((String)value));
                    continue block13;
                }
                case NAME: {
                    builder.name(value);
                    continue block13;
                }
                case MAX_CONTENT_LENGTH: {
                    builder.maxContentLength(Integer.parseInt(value));
                    continue block13;
                }
                case COMPRESSION_LEVEL: {
                    builder.compressionLevel(Integer.parseInt(value));
                    continue block13;
                }
                case SOCKET_BINDING: {
                    builder.socketBinding(value);
                    serverBuilder.applySocketBinding(value, (ProtocolServerConfigurationBuilder)builder);
                    builder.startTransport(true);
                    dedicatedSocketBinding = true;
                    continue block13;
                }
                default: {
                    ServerConfigurationParser.parseCommonConnectorAttributes(reader, i, serverBuilder, builder);
                }
            }
        }
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHENTICATION: {
                    this.parseAuthentication(reader, serverBuilder, builder.authentication().enable());
                    continue block14;
                }
                case ENCRYPTION: {
                    if (!dedicatedSocketBinding) {
                        throw Server.log.cannotConfigureProtocolEncryptionUnderSinglePort();
                    }
                    this.parseEncryption(reader, serverBuilder, builder.encryption());
                    continue block14;
                }
                case CORS_RULES: {
                    this.parseCorsRules(reader, builder);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseCorsRules(XMLExtendedStreamReader reader, RestServerConfigurationBuilder builder) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
        CorsConfigurationBuilder cors = builder.cors();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CORS_RULE: {
                    this.parseCorsRule(reader, cors.addNewRule());
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseCorsRule(XMLExtendedStreamReader reader, CorsRuleConfigurationBuilder corsRule) throws XMLStreamException {
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    corsRule.name(value);
                    continue block11;
                }
                case ALLOW_CREDENTIALS: {
                    corsRule.allowCredentials(Boolean.parseBoolean(value));
                    continue block11;
                }
                case MAX_AGE_SECONDS: {
                    corsRule.maxAge(Long.parseLong(value));
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            String[] values = reader.getElementText().split(",");
            switch (element) {
                case ALLOWED_HEADERS: {
                    corsRule.allowHeaders(values);
                    continue block12;
                }
                case ALLOWED_ORIGINS: {
                    corsRule.allowOrigins(values);
                    continue block12;
                }
                case ALLOWED_METHODS: {
                    corsRule.allowMethods(values);
                    continue block12;
                }
                case EXPOSE_HEADERS: {
                    corsRule.exposeHeaders(values);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseAuthentication(XMLExtendedStreamReader reader, ServerConfigurationBuilder serverBuilder, AuthenticationConfigurationBuilder builder) throws XMLStreamException {
        ServerSecurityRealm securityRealm = serverBuilder.endpoint().securityRealm();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SECURITY_REALM: {
                    builder.securityRealm(value);
                    securityRealm = serverBuilder.getSecurityRealm(value);
                    continue block4;
                }
                case MECHANISMS: {
                    builder.addMechanisms(reader.getListAttributeValue(i));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        if (securityRealm == null) {
            throw Server.log.authenticationWithoutSecurityRealm();
        }
        builder.authenticator(securityRealm.getHTTPAuthenticationProvider());
    }

    private void parseEncryption(XMLExtendedStreamReader reader, ServerConfigurationBuilder serverBuilder, EncryptionConfigurationBuilder encryption) throws XMLStreamException {
        String securityRealm = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.SECURITY_REALM})[0];
        SSLContext sslContext = serverBuilder.getSSLContext(securityRealm);
        encryption.realm(securityRealm).sslContext(sslContext);
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case REQUIRE_SSL_CLIENT_AUTH: {
                    encryption.requireClientAuth(Boolean.parseBoolean(value));
                    continue block7;
                }
                case SECURITY_REALM: {
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        boolean skipTagCheckAtTheEnd = reader.hasNext();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SNI: {
                    this.parseSni(reader, serverBuilder, encryption.addSni());
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        if (!skipTagCheckAtTheEnd) {
            ParseUtils.requireNoContent((XMLStreamReader)reader);
        }
    }

    private void parseSni(XMLExtendedStreamReader reader, ServerConfigurationBuilder serverBuilder, SniConfigurationBuilder sni) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST_NAME: {
                    sni.host(value);
                    continue block4;
                }
                case SECURITY_REALM: {
                    sni.realm(value);
                    sni.sslContext(serverBuilder.getSSLContext(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }
}

