/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.Arrays;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.JwtConfiguration;
import org.infinispan.server.configuration.security.KeyStoreConfiguration;
import org.infinispan.server.configuration.security.OAuth2Configuration;

public class TokenRealmConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((String)"name", null, String.class).build();
    static final AttributeDefinition<String> PRINCIPAL_CLAIM = AttributeDefinition.builder((String)"principalClaim", null, String.class).build();
    private final JwtConfiguration jwtConfiguration;
    private final OAuth2Configuration oAuth2Configuration;
    private final List<ConfigurationInfo> elements;
    private static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.TOKEN_REALM.toString());
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(KeyStoreConfiguration.class, new AttributeDefinition[]{NAME, PRINCIPAL_CLAIM});
    }

    TokenRealmConfiguration(JwtConfiguration jwtConfiguration, OAuth2Configuration oAuth2Configuration, AttributeSet attributes) {
        this.jwtConfiguration = jwtConfiguration;
        this.oAuth2Configuration = oAuth2Configuration;
        this.attributes = attributes.checkProtection();
        this.elements = Arrays.asList(jwtConfiguration, oAuth2Configuration);
    }

    public List<ConfigurationInfo> subElements() {
        return this.elements;
    }

    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    JwtConfiguration jwtConfiguration() {
        return this.jwtConfiguration;
    }

    OAuth2Configuration oauth2Configuration() {
        return this.oAuth2Configuration;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }
}

