/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.JwtConfigurationBuilder;
import org.infinispan.server.configuration.security.OAuth2ConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.TokenRealmConfiguration;
import org.infinispan.server.security.KeycloakRoleDecoder;
import org.wildfly.security.auth.realm.token.TokenSecurityRealm;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.realm.token.validator.JwtValidator;
import org.wildfly.security.auth.realm.token.validator.OAuth2IntrospectValidator;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.RoleDecoder;

public class TokenRealmConfigurationBuilder
implements Builder<TokenRealmConfiguration> {
    private final AttributeSet attributes;
    private final TokenSecurityRealm.Builder tokenRealmBuilder = TokenSecurityRealm.builder();
    private final JwtConfigurationBuilder jwtConfiguration;
    private final OAuth2ConfigurationBuilder oauth2Configuration;
    private final RealmConfigurationBuilder realmBuilder;
    private TokenSecurityRealm securityRealm;

    public TokenRealmConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.realmBuilder = realmBuilder;
        this.attributes = TokenRealmConfiguration.attributeDefinitionSet();
        this.jwtConfiguration = new JwtConfigurationBuilder(realmBuilder);
        this.oauth2Configuration = new OAuth2ConfigurationBuilder(realmBuilder.realmsBuilder());
    }

    public JwtConfigurationBuilder jwtConfiguration() {
        return this.jwtConfiguration;
    }

    public OAuth2ConfigurationBuilder oauth2Configuration() {
        return this.oauth2Configuration;
    }

    public TokenRealmConfigurationBuilder name(String name) {
        this.attributes.attribute(TokenRealmConfiguration.NAME).set((Object)name);
        return this;
    }

    public TokenRealmConfigurationBuilder principalClaim(String principalClaim) {
        this.attributes.attribute(TokenRealmConfiguration.PRINCIPAL_CLAIM).set((Object)principalClaim);
        return this;
    }

    public TokenSecurityRealm build() {
        if (this.securityRealm == null) {
            OAuth2IntrospectValidator validator;
            if (this.oauth2Configuration.isChanged() && this.jwtConfiguration.isChanged()) {
                throw new CacheConfigurationException("Cannot have both Oauth2 and JWT as validators");
            }
            if (!this.oauth2Configuration.isChanged() && !this.jwtConfiguration.isChanged()) {
                return null;
            }
            SecurityDomain.Builder domainBuilder = this.realmBuilder.domainBuilder();
            String name = (String)this.attributes.attribute(TokenRealmConfiguration.NAME).get();
            if (this.oauth2Configuration.isChanged()) {
                OAuth2IntrospectValidator.Builder oauthValidatorBuilder = this.oauth2Configuration.getValidatorBuilder();
                validator = oauthValidatorBuilder.build();
            } else {
                JwtValidator.Builder jwtValidatorBuilder = this.jwtConfiguration.getValidatorBuilder();
                validator = jwtValidatorBuilder.build();
            }
            this.tokenRealmBuilder.validator((TokenValidator)validator);
            this.securityRealm = this.tokenRealmBuilder.build();
            domainBuilder.addRealm(name, (SecurityRealm)this.securityRealm).setRoleDecoder((RoleDecoder)new KeycloakRoleDecoder()).build();
        }
        return this.securityRealm;
    }

    public void validate() {
        this.jwtConfiguration.validate();
        this.oauth2Configuration.validate();
    }

    public TokenRealmConfiguration create() {
        return new TokenRealmConfiguration(this.jwtConfiguration.create(), this.oauth2Configuration.create(), this.attributes.protect());
    }

    public TokenRealmConfigurationBuilder read(TokenRealmConfiguration template) {
        this.attributes.read(template.attributes());
        this.jwtConfiguration.read(template.jwtConfiguration());
        this.oauth2Configuration.read(template.oauth2Configuration());
        return this;
    }
}

