/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.logging;

import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.server.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String serverStarting = "ISPN080000: %s Server starting";
    private static final String serverStarted = "ISPN080001: %s Server %s started in %dms";
    private static final String serverStopping = "ISPN080002: %s Server stopping";
    private static final String serverStopped = "ISPN080003: %s Server stopped";
    private static final String protocolStarted3 = "ISPN080004: Protocol %s listening on %s:%d";
    private static final String duplicatePath = "ISPN080005: Duplicate path '%s'";
    private static final String duplicateNetworkInterface = "ISPN080006: Duplicate network interface '%s'";
    private static final String duplicateSocketBinding = "ISPN080007: Duplicate socket binding '%s'";
    private static final String cannotInstantiateProtocolServerConfigurationBuilder = "ISPN080008: Cannot instantiate protocol server configuration '%s'";
    private static final String unknownInterface = "ISPN080009: Unknown interface '%s'";
    private static final String unknownSocketBinding = "ISPN080010: Unknown socket binding '%s'";
    private static final String nonAbsolutePath = "ISPN080011: The path '%s' is not absolute";
    private static final String duplicateSecurityRealm = "ISPN080012: Duplicate security domain '%s'";
    private static final String duplicateRealmType = "ISPN080013: Duplicate realm type '%s' in realm '%s'";
    private static final String unknownSecurityDomain = "ISPN080014: Unknown security domain '%s'";
    private static final String unableToLoadRealmPropertyFiles = "ISPN080015: Unable to load realm property files";
    private static final String noDefaultKeyManager = "ISPN080016: No default key manager available";
    private static final String serverConfiguration = "ISPN080017: Server configuration: %s";
    private static final String protocolStarted1 = "ISPN080018: Protocol %s (internal)";
    private static final String routerStarted = "ISPN080019: Protocol Router listening on %s:%d";
    private static final String trustStoreWithoutServerIdentity = "ISPN080020: Cannot use a trust store without a server identity";
    private static final String authenticationWithoutSecurityRealm = "ISPN080021: Authentication cannot be configured without a security realm";
    private static final String cannotConfigureProtocolEncryptionUnderSinglePort = "ISPN080022: Cannot configure protocol encryption under a single port endpoint. Use a dedicated socket binding.";
    private static final String protocolCannotUseSameSocketBindingAsEndpoint = "ISPN080023: Cannot configure a protocol with the same socket binding used by the endpoint. Use a dedicated socket binding.";
    private static final String invalidUrl = "ISPN080024: Invalid URL";
    private static final String multipleEndpointsSameTypeFound = "ISPN080025: Cannot have multiple connectors of the same type: found [%s]";
    private static final String unnamedFactoryClass = "ISPN080026: Extension factory '%s' is lacking a @NamedFactory annotation";
    private static final String loadedExtension = "ISPN080027: Loaded extension '%s'";
    private static final String serverFailedToStart = "ISPN080028: %s Server failed to start";
    private static final String clusterShutdown = "ISPN080029: Cluster shutdown";
    private static final String clusteredTaskError = "ISPN080030: Clustered task error";
    private static final String unknownServerIdentity = "ISPN080031: Unknown server identity '%s'";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void serverStarting(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStarting$str(), (Object)name);
    }

    protected String serverStarting$str() {
        return serverStarting;
    }

    @Override
    public final void serverStarted(String name, String version, long ms) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStarted$str(), (Object)name, (Object)version, (Object)ms);
    }

    protected String serverStarted$str() {
        return serverStarted;
    }

    @Override
    public final void serverStopping(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStopping$str(), (Object)name);
    }

    protected String serverStopping$str() {
        return serverStopping;
    }

    @Override
    public final void serverStopped(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStopped$str(), (Object)name);
    }

    protected String serverStopped$str() {
        return serverStopped;
    }

    @Override
    public final void protocolStarted(String name, String host, int port) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.protocolStarted3$str(), (Object)name, (Object)host, (Object)port);
    }

    protected String protocolStarted3$str() {
        return protocolStarted3;
    }

    protected String duplicatePath$str() {
        return duplicatePath;
    }

    @Override
    public final CacheConfigurationException duplicatePath(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicatePath$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateNetworkInterface$str() {
        return duplicateNetworkInterface;
    }

    @Override
    public final CacheConfigurationException duplicateNetworkInterface(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateNetworkInterface$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateSocketBinding$str() {
        return duplicateSocketBinding;
    }

    @Override
    public final CacheConfigurationException duplicateSocketBinding(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateSocketBinding$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInstantiateProtocolServerConfigurationBuilder$str() {
        return cannotInstantiateProtocolServerConfigurationBuilder;
    }

    @Override
    public final CacheConfigurationException cannotInstantiateProtocolServerConfigurationBuilder(Class<?> klass, Exception e) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotInstantiateProtocolServerConfigurationBuilder$str(), klass), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownInterface$str() {
        return unknownInterface;
    }

    @Override
    public final CacheConfigurationException unknownInterface(String interfaceName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unknownInterface$str(), interfaceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownSocketBinding$str() {
        return unknownSocketBinding;
    }

    @Override
    public final CacheConfigurationException unknownSocketBinding(String value) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unknownSocketBinding$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonAbsolutePath$str() {
        return nonAbsolutePath;
    }

    @Override
    public final CacheConfigurationException nonAbsolutePath(String path) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.nonAbsolutePath$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateSecurityRealm$str() {
        return duplicateSecurityRealm;
    }

    @Override
    public final CacheConfigurationException duplicateSecurityRealm(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateSecurityRealm$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateRealmType$str() {
        return duplicateRealmType;
    }

    @Override
    public final CacheConfigurationException duplicateRealmType(String type, String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateRealmType$str(), type, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownSecurityDomain$str() {
        return unknownSecurityDomain;
    }

    @Override
    public final CacheConfigurationException unknownSecurityDomain(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unknownSecurityDomain$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadRealmPropertyFiles$str() {
        return unableToLoadRealmPropertyFiles;
    }

    @Override
    public final CacheConfigurationException unableToLoadRealmPropertyFiles(IOException e) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unableToLoadRealmPropertyFiles$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDefaultKeyManager$str() {
        return noDefaultKeyManager;
    }

    @Override
    public final NoSuchAlgorithmException noDefaultKeyManager() {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noDefaultKeyManager$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void serverConfiguration(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverConfiguration$str(), (Object)name);
    }

    protected String serverConfiguration$str() {
        return serverConfiguration;
    }

    @Override
    public final void protocolStarted(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.protocolStarted1$str(), (Object)name);
    }

    protected String protocolStarted1$str() {
        return protocolStarted1;
    }

    @Override
    public final void routerStarted(String host, int port) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.routerStarted$str(), (Object)host, (Object)port);
    }

    protected String routerStarted$str() {
        return routerStarted;
    }

    protected String trustStoreWithoutServerIdentity$str() {
        return trustStoreWithoutServerIdentity;
    }

    @Override
    public final CacheConfigurationException trustStoreWithoutServerIdentity() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.trustStoreWithoutServerIdentity$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String authenticationWithoutSecurityRealm$str() {
        return authenticationWithoutSecurityRealm;
    }

    @Override
    public final CacheConfigurationException authenticationWithoutSecurityRealm() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.authenticationWithoutSecurityRealm$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConfigureProtocolEncryptionUnderSinglePort$str() {
        return cannotConfigureProtocolEncryptionUnderSinglePort;
    }

    @Override
    public final CacheConfigurationException cannotConfigureProtocolEncryptionUnderSinglePort() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotConfigureProtocolEncryptionUnderSinglePort$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String protocolCannotUseSameSocketBindingAsEndpoint$str() {
        return protocolCannotUseSameSocketBindingAsEndpoint;
    }

    @Override
    public final CacheConfigurationException protocolCannotUseSameSocketBindingAsEndpoint() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.protocolCannotUseSameSocketBindingAsEndpoint$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidUrl$str() {
        return invalidUrl;
    }

    @Override
    public final CacheConfigurationException invalidUrl() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidUrl$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleEndpointsSameTypeFound$str() {
        return multipleEndpointsSameTypeFound;
    }

    @Override
    public final CacheConfigurationException multipleEndpointsSameTypeFound(String names) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.multipleEndpointsSameTypeFound$str(), names));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void unnamedFactoryClass(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unnamedFactoryClass$str(), (Object)name);
    }

    protected String unnamedFactoryClass$str() {
        return unnamedFactoryClass;
    }

    @Override
    public final void loadedExtension(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.loadedExtension$str(), (Object)name);
    }

    protected String loadedExtension$str() {
        return loadedExtension;
    }

    @Override
    public final void serverFailedToStart(String name, Exception e) {
        this.log.logf(FQCN, Logger.Level.FATAL, (Throwable)e, this.serverFailedToStart$str(), (Object)name);
    }

    protected String serverFailedToStart$str() {
        return serverFailedToStart;
    }

    @Override
    public final void clusterShutdown() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.clusterShutdown$str(), new Object[0]);
    }

    protected String clusterShutdown$str() {
        return clusterShutdown;
    }

    @Override
    public final void clusteredTaskError(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.clusteredTaskError$str(), new Object[0]);
    }

    protected String clusteredTaskError$str() {
        return clusteredTaskError;
    }

    protected String unknownServerIdentity$str() {
        return unknownServerIdentity;
    }

    @Override
    public final IllegalArgumentException unknownServerIdentity(String serverPrincipal) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownServerIdentity$str(), serverPrincipal));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

