/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.network;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.function.Predicate;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.server.Server;

public class NetworkAddress {
    private final String name;
    private final InetAddress address;

    NetworkAddress(String name, InetAddress address) {
        this.name = name;
        this.address = address;
    }

    public String getName() {
        return this.name;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String toString() {
        return "NetworkInterfaceImpl{name='" + this.name + '\'' + ", address=" + this.address + '}';
    }

    public static NetworkAddress fromString(String name, String value) {
        switch (value) {
            case "GLOBAL": {
                return NetworkAddress.globalAddress(name);
            }
            case "LOOPBACK": {
                return NetworkAddress.loopback(name);
            }
            case "NON_LOOPBACK": {
                return NetworkAddress.nonLoopback(name);
            }
            case "SITE_LOCAL": {
                return NetworkAddress.siteLocal(name);
            }
            case "LINK_LOCAL": {
                return NetworkAddress.linkLocalAddress(name);
            }
        }
        if (value.startsWith("match-interface:")) {
            return NetworkAddress.matchInterface(name, value.substring(value.indexOf(58) + 1));
        }
        if (value.startsWith("match-address:")) {
            return NetworkAddress.matchAddress(name, value.substring(value.indexOf(58) + 1));
        }
        if (value.startsWith("match-host:")) {
            return NetworkAddress.matchHost(name, value.substring(value.indexOf(58) + 1));
        }
        return NetworkAddress.inetAddress(name, value);
    }

    public static NetworkAddress globalAddress(String name) {
        return new NetworkAddress(name, NetworkAddress.findAddress(a -> !a.isLoopbackAddress() && !a.isSiteLocalAddress() && !a.isLinkLocalAddress()));
    }

    public static NetworkAddress loopback(String name) {
        return new NetworkAddress(name, NetworkAddress.findAddress(a -> a.isLoopbackAddress()));
    }

    public static NetworkAddress nonLoopback(String name) {
        return new NetworkAddress(name, NetworkAddress.findAddress(a -> !a.isLoopbackAddress()));
    }

    public static NetworkAddress siteLocal(String name) {
        return new NetworkAddress(name, NetworkAddress.findAddress(a -> a.isSiteLocalAddress()));
    }

    public static NetworkAddress matchInterface(String name, String regex) {
        return new NetworkAddress(name, NetworkAddress.findInterface(i -> i.getName().matches(regex)).getInetAddresses().nextElement());
    }

    public static NetworkAddress matchAddress(String name, String regex) {
        return new NetworkAddress(name, NetworkAddress.findAddress(a -> a.getHostAddress().matches(regex)));
    }

    public static NetworkAddress matchHost(String name, String regex) {
        return new NetworkAddress(name, NetworkAddress.findAddress(a -> a.getHostName().matches(regex)));
    }

    public static NetworkAddress inetAddress(String name, String value) {
        try {
            return new NetworkAddress(name, InetAddress.getByName(value));
        }
        catch (UnknownHostException e) {
            throw new CacheConfigurationException((Exception)e);
        }
    }

    public static NetworkAddress linkLocalAddress(String name) {
        return new NetworkAddress(name, NetworkAddress.findAddress(a -> a.isLinkLocalAddress()));
    }

    static InetAddress findAddress(Predicate<InetAddress> matcher) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (!networkInterface.isUp()) continue;
                if (Server.log.isDebugEnabled()) {
                    Server.log.debugf("Network interface %s", networkInterface);
                }
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (Server.log.isDebugEnabled()) {
                        Server.log.debugf("Network address %s (%b %b %b)", new Object[]{address, address.isLoopbackAddress(), address.isLinkLocalAddress(), address.isSiteLocalAddress()});
                    }
                    if (!matcher.test(address)) continue;
                    return address;
                }
            }
        }
        catch (SocketException e) {
            throw new CacheConfigurationException((Exception)e);
        }
        throw new CacheConfigurationException("No matching addresses found");
    }

    private static NetworkInterface findInterface(Predicate<NetworkInterface> matcher) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (!networkInterface.isUp()) continue;
                if (Server.log.isDebugEnabled()) {
                    Server.log.debugf("Network interface %s", networkInterface);
                }
                if (!matcher.test(networkInterface)) continue;
                return networkInterface;
            }
        }
        catch (SocketException e) {
            throw new CacheConfigurationException((Exception)e);
        }
        throw new CacheConfigurationException("No matching interface found");
    }
}

