/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.endpoint;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.endpoint.EndpointsConfiguration;
import org.infinispan.server.configuration.endpoint.SinglePortServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;

public class EndpointsConfigurationBuilder
implements Builder<EndpointsConfiguration> {
    private final AttributeSet attributes;
    private final ServerConfigurationBuilder serverConfigurationBuilder;
    private final List<ProtocolServerConfigurationBuilder<?, ?>> connectors = new ArrayList(2);
    private final SinglePortServerConfigurationBuilder singlePort = new SinglePortServerConfigurationBuilder();

    public EndpointsConfigurationBuilder(ServerConfigurationBuilder serverConfigurationBuilder) {
        this.serverConfigurationBuilder = serverConfigurationBuilder;
        this.attributes = EndpointsConfiguration.attributeDefinitionSet();
    }

    public EndpointsConfigurationBuilder socketBinding(String name) {
        this.attributes.attribute(EndpointsConfiguration.SOCKET_BINDING).set((Object)name);
        this.serverConfigurationBuilder.applySocketBinding(name, this.serverConfigurationBuilder.endpoint());
        return this;
    }

    public EndpointsConfigurationBuilder securityRealm(String name) {
        this.attributes.attribute(EndpointsConfiguration.SECURITY_REALM).set((Object)name);
        this.serverConfigurationBuilder.endpoint().securityRealm(this.serverConfigurationBuilder.getSecurityRealm(name));
        return this;
    }

    public List<ProtocolServerConfigurationBuilder<?, ?>> connectors() {
        return this.connectors;
    }

    public SinglePortServerConfigurationBuilder singlePort() {
        return this.singlePort;
    }

    public <T extends ProtocolServerConfigurationBuilder<?, ?>> T addConnector(Class<T> klass) {
        try {
            ProtocolServerConfigurationBuilder builder = (ProtocolServerConfigurationBuilder)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.connectors.add(builder);
            this.singlePort.applyConfigurationToProtocol(builder);
            return (T)builder;
        }
        catch (Exception e) {
            throw Server.log.cannotInstantiateProtocolServerConfigurationBuilder(klass, e);
        }
    }

    public void validate() {
        Map<Class, List<ProtocolServerConfigurationBuilder>> buildersPerClass = this.connectors.stream().collect(Collectors.groupingBy(Object::getClass));
        Optional<Map.Entry> repeated = buildersPerClass.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).findFirst();
        repeated.ifPresent(e -> {
            String names = ((List)e.getValue()).stream().map(ProtocolServerConfigurationBuilder::name).collect(Collectors.joining(","));
            throw Server.log.multipleEndpointsSameTypeFound(names);
        });
    }

    public EndpointsConfiguration create() {
        List<ProtocolServerConfiguration> configs = this.connectors.stream().map(b -> (ProtocolServerConfiguration)b.create()).collect(Collectors.toList());
        return new EndpointsConfiguration(this.attributes.protect(), configs, this.singlePort.create());
    }

    public EndpointsConfigurationBuilder read(EndpointsConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

