package org.infinispan.server.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.lang.String;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.FATAL;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-05-07T09:15:08-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void serverStarting(final String name) {
        super.log.logf(FQCN, INFO, null, serverStarting$str(), name);
    }
    private static final String serverStarting = "ISPN080000: %s Server starting";
    protected String serverStarting$str() {
        return serverStarting;
    }
    @Override
    public final void serverStarted(final String name, final String version, final long ms) {
        super.log.logf(FQCN, INFO, null, serverStarted$str(), name, version, ms);
    }
    private static final String serverStarted = "ISPN080001: %s Server %s started in %dms";
    protected String serverStarted$str() {
        return serverStarted;
    }
    @Override
    public final void serverStopping(final String name) {
        super.log.logf(FQCN, INFO, null, serverStopping$str(), name);
    }
    private static final String serverStopping = "ISPN080002: %s Server stopping";
    protected String serverStopping$str() {
        return serverStopping;
    }
    @Override
    public final void serverStopped(final String name) {
        super.log.logf(FQCN, INFO, null, serverStopped$str(), name);
    }
    private static final String serverStopped = "ISPN080003: %s Server stopped";
    protected String serverStopped$str() {
        return serverStopped;
    }
    @Override
    public final void protocolStarted(final String name, final String host, final int port) {
        super.log.logf(FQCN, INFO, null, protocolStarted3$str(), name, host, port);
    }
    private static final String protocolStarted3 = "ISPN080004: Protocol %s listening on %s:%d";
    protected String protocolStarted3$str() {
        return protocolStarted3;
    }
    private static final String cannotInstantiateProtocolServerConfigurationBuilder = "ISPN080008: Cannot instantiate protocol server configuration '%s'";
    protected String cannotInstantiateProtocolServerConfigurationBuilder$str() {
        return cannotInstantiateProtocolServerConfigurationBuilder;
    }
    @Override
    public final CacheConfigurationException cannotInstantiateProtocolServerConfigurationBuilder(final Class<?> klass, final Exception e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotInstantiateProtocolServerConfigurationBuilder$str(), klass), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownInterface = "ISPN080009: Unknown interface '%s'";
    protected String unknownInterface$str() {
        return unknownInterface;
    }
    @Override
    public final CacheConfigurationException unknownInterface(final String interfaceName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownInterface$str(), interfaceName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownSocketBinding = "ISPN080010: Unknown socket binding '%s'";
    protected String unknownSocketBinding$str() {
        return unknownSocketBinding;
    }
    @Override
    public final CacheConfigurationException unknownSocketBinding(final String value) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownSocketBinding$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownSecurityDomain = "ISPN080014: Unknown security domain '%s'";
    protected String unknownSecurityDomain$str() {
        return unknownSecurityDomain;
    }
    @Override
    public final CacheConfigurationException unknownSecurityDomain(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownSecurityDomain$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadRealmPropertyFiles = "ISPN080015: Unable to load realm property files";
    protected String unableToLoadRealmPropertyFiles$str() {
        return unableToLoadRealmPropertyFiles;
    }
    @Override
    public final CacheConfigurationException unableToLoadRealmPropertyFiles(final IOException e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unableToLoadRealmPropertyFiles$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDefaultKeyManager = "ISPN080016: No default key manager available";
    protected String noDefaultKeyManager$str() {
        return noDefaultKeyManager;
    }
    @Override
    public final NoSuchAlgorithmException noDefaultKeyManager() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noDefaultKeyManager$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void serverConfiguration(final String name) {
        super.log.logf(FQCN, INFO, null, serverConfiguration$str(), name);
    }
    private static final String serverConfiguration = "ISPN080017: Server configuration: %s";
    protected String serverConfiguration$str() {
        return serverConfiguration;
    }
    @Override
    public final void protocolStarted(final String name) {
        super.log.logf(FQCN, INFO, null, protocolStarted1$str(), name);
    }
    private static final String protocolStarted1 = "ISPN080018: Protocol %s (internal)";
    protected String protocolStarted1$str() {
        return protocolStarted1;
    }
    private static final String trustStoreWithoutServerIdentity = "ISPN080020: Cannot use a trust store without a server identity";
    protected String trustStoreWithoutServerIdentity$str() {
        return trustStoreWithoutServerIdentity;
    }
    @Override
    public final CacheConfigurationException trustStoreWithoutServerIdentity() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), trustStoreWithoutServerIdentity$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authenticationWithoutSecurityRealm = "ISPN080021: Authentication cannot be configured without a security realm";
    protected String authenticationWithoutSecurityRealm$str() {
        return authenticationWithoutSecurityRealm;
    }
    @Override
    public final CacheConfigurationException authenticationWithoutSecurityRealm() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), authenticationWithoutSecurityRealm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotConfigureProtocolEncryptionUnderSinglePort = "ISPN080022: Cannot configure protocol encryption under a single port endpoint. Use a dedicated socket binding.";
    protected String cannotConfigureProtocolEncryptionUnderSinglePort$str() {
        return cannotConfigureProtocolEncryptionUnderSinglePort;
    }
    @Override
    public final CacheConfigurationException cannotConfigureProtocolEncryptionUnderSinglePort() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotConfigureProtocolEncryptionUnderSinglePort$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String protocolCannotUseSameSocketBindingAsEndpoint = "ISPN080023: Cannot configure a protocol with the same socket binding used by the endpoint. Use a dedicated socket binding.";
    protected String protocolCannotUseSameSocketBindingAsEndpoint$str() {
        return protocolCannotUseSameSocketBindingAsEndpoint;
    }
    @Override
    public final CacheConfigurationException protocolCannotUseSameSocketBindingAsEndpoint() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), protocolCannotUseSameSocketBindingAsEndpoint$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidUrl = "ISPN080024: Invalid URL";
    protected String invalidUrl$str() {
        return invalidUrl;
    }
    @Override
    public final CacheConfigurationException invalidUrl() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidUrl$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleEndpointsSameTypeFound = "ISPN080025: Cannot have multiple connectors of the same type: found [%s]";
    protected String multipleEndpointsSameTypeFound$str() {
        return multipleEndpointsSameTypeFound;
    }
    @Override
    public final CacheConfigurationException multipleEndpointsSameTypeFound(final String names) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), multipleEndpointsSameTypeFound$str(), names));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unnamedFactoryClass(final String name) {
        super.log.logf(FQCN, WARN, null, unnamedFactoryClass$str(), name);
    }
    private static final String unnamedFactoryClass = "ISPN080026: Extension factory '%s' is lacking a @NamedFactory annotation";
    protected String unnamedFactoryClass$str() {
        return unnamedFactoryClass;
    }
    @Override
    public final void loadedExtension(final String name) {
        super.log.logf(FQCN, INFO, null, loadedExtension$str(), name);
    }
    private static final String loadedExtension = "ISPN080027: Loaded extension '%s'";
    protected String loadedExtension$str() {
        return loadedExtension;
    }
    @Override
    public final void serverFailedToStart(final String name, final Exception e) {
        super.log.logf(FQCN, FATAL, e, serverFailedToStart$str(), name);
    }
    private static final String serverFailedToStart = "ISPN080028: %s Server failed to start";
    protected String serverFailedToStart$str() {
        return serverFailedToStart;
    }
    @Override
    public final void clusterShutdown() {
        super.log.logf(FQCN, INFO, null, clusterShutdown$str());
    }
    private static final String clusterShutdown = "ISPN080029: Cluster shutdown";
    protected String clusterShutdown$str() {
        return clusterShutdown;
    }
    @Override
    public final void clusteredTaskError(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, clusteredTaskError$str());
    }
    private static final String clusteredTaskError = "ISPN080030: Clustered task error";
    protected String clusteredTaskError$str() {
        return clusteredTaskError;
    }
    private static final String unknownServerIdentity = "ISPN080031: Unknown server identity '%s'";
    protected String unknownServerIdentity$str() {
        return unknownServerIdentity;
    }
    @Override
    public final IllegalArgumentException unknownServerIdentity(final String serverPrincipal) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownServerIdentity$str(), serverPrincipal));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void loggingConfiguration(final String absolutePath) {
        super.log.logf(FQCN, INFO, null, loggingConfiguration$str(), absolutePath);
    }
    private static final String loggingConfiguration = "ISPN080032: Logging configuration: %s";
    protected String loggingConfiguration$str() {
        return loggingConfiguration;
    }
    private static final String invalidNetworkConfiguration = "ISPN080033: Cannot find a network address which matches the supplied configuration";
    protected String invalidNetworkConfiguration$str() {
        return invalidNetworkConfiguration;
    }
    @Override
    public final CacheConfigurationException invalidNetworkConfiguration() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidNetworkConfiguration$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void endpointUrl(final Object name, final String proto, final String host, final int port) {
        super.log.logf(FQCN, INFO, null, endpointUrl$str(), name, proto, host, port);
    }
    private static final String endpointUrl = "ISPN080034: Server '%s' listening on %s://%s:%d";
    protected String endpointUrl$str() {
        return endpointUrl;
    }
}
