/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server;

import java.io.File;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.logging.Logger;
import org.infinispan.commons.util.Version;
import org.infinispan.server.DefaultExitHandler;
import org.infinispan.server.ExitHandler;
import org.infinispan.server.Server;
import org.infinispan.server.ShutdownHook;
import org.infinispan.server.logging.Messages;
import org.infinispan.server.tool.Main;

public class Bootstrap
extends Main {
    private final ExitHandler exitHandler;
    private File configurationFile;
    private File loggingFile;

    public Bootstrap(PrintStream stdOut, PrintStream stdErr, ExitHandler exitHandler, Properties properties) {
        super(stdOut, stdErr, properties);
        this.exitHandler = exitHandler;
    }

    public static void main(String[] args) {
        Bootstrap bootstrap = new Bootstrap(System.out, System.err, new DefaultExitHandler(), System.getProperties());
        bootstrap.run(args);
    }

    @Override
    protected void handleArgumentCommand(String command, String parameter, Iterator<String> args) {
        switch (command) {
            case "-c": {
                parameter = args.next();
            }
            case "--server-config": {
                this.configurationFile = new File(parameter);
                break;
            }
            case "-l": {
                parameter = args.next();
            }
            case "--logging-config": {
                this.loggingFile = new File(parameter);
                break;
            }
            case "-s": {
                parameter = args.next();
            }
            case "--server-root": {
                this.serverRoot = new File(parameter);
                break;
            }
            case "-b": {
                parameter = args.next();
            }
            case "--bind-address": {
                this.properties.setProperty("infinispan.bind.address", parameter);
                break;
            }
            case "-p": {
                parameter = args.next();
            }
            case "--bind-port": {
                this.properties.setProperty("infinispan.bind.port", parameter);
                break;
            }
            case "-n": {
                parameter = args.next();
            }
            case "--node-name": {
                this.properties.setProperty("infinispan.node.name", parameter);
                break;
            }
            case "-g": {
                parameter = args.next();
            }
            case "--cluster-name": {
                this.properties.setProperty("infinispan.cluster.name", parameter);
                break;
            }
            case "-j": {
                parameter = args.next();
            }
            case "--cluster-stack": {
                this.properties.setProperty("infinispan.cluster.stack", parameter);
                break;
            }
            case "-k": {
                parameter = args.next();
            }
            case "--cluster-address": {
                this.properties.setProperty("jgroups.bind.address", parameter);
                break;
            }
            case "-o": {
                parameter = args.next();
            }
            case "--port-offset": {
                this.properties.setProperty("infinispan.socket.binding.port-offset", parameter);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void runInternal() {
        if (!this.serverRoot.isAbsolute()) {
            this.serverRoot = this.serverRoot.getAbsoluteFile();
        }
        File confDir = new File(this.serverRoot, "conf");
        if (this.configurationFile == null) {
            this.configurationFile = new File(confDir, "infinispan.xml");
        } else if (!this.configurationFile.isAbsolute()) {
            this.configurationFile = Paths.get(confDir.getPath(), this.configurationFile.getPath()).toFile();
        }
        File logDir = new File(this.serverRoot, "log");
        this.properties.putIfAbsent("infinispan.server.log.path", logDir.getAbsolutePath());
        if (this.loggingFile == null) {
            this.loggingFile = new File(confDir, "log4j2.xml");
        } else if (!this.loggingFile.isAbsolute()) {
            this.loggingFile = Paths.get(confDir.getPath(), this.loggingFile.getPath()).toFile();
        }
        System.setProperty("log4j.configurationFile", this.loggingFile.getAbsolutePath());
        if (!this.loggingFile.canRead()) {
            this.stdErr.printf("Cannot read %s", this.loggingFile);
            return;
        }
        this.logJVMInformation();
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(this.exitHandler));
        Server.log.serverStarting(Version.getBrandName());
        Server.log.serverConfiguration(this.configurationFile.getAbsolutePath());
        Server.log.loggingConfiguration(this.loggingFile.getAbsolutePath());
        try (Server server = new Server(this.serverRoot, this.configurationFile, this.properties);){
            server.setExitHandler(this.exitHandler);
            server.run().get();
        }
        catch (Exception e) {
            Server.log.serverFailedToStart(Version.getBrandName(), e);
        }
    }

    @Override
    public void help(PrintStream out) {
        out.printf("Usage:\n", new Object[0]);
        out.printf("  -b, --bind-address=<address>  %s\n", Messages.MSG.serverHelpBindAddress());
        out.printf("  -c, --server-config=<config>  %s\n", Messages.MSG.serverHelpServerConfig("infinispan.xml"));
        out.printf("  -l, --logging-config=<config> %s\n", Messages.MSG.serverHelpLoggingConfig("log4j2.xml"));
        out.printf("  -g, --cluster-name=<name>     %s\n", Messages.MSG.serverHelpClusterName("cluster"));
        out.printf("  -h, --help                    %s\n", Messages.MSG.toolHelpHelp());
        out.printf("  -j, --cluster-stack=<name>    %s\n", Messages.MSG.serverHelpClusterStack("tcp"));
        out.printf("  -k, --cluster-address=<name>  %s\n", Messages.MSG.serverHelpClusterAddress());
        out.printf("  -n, --node-name=<name>        %s\n", Messages.MSG.serverHelpNodeName());
        out.printf("  -o, --port-offset=<offset>    %s\n", Messages.MSG.serverHelpPortOffset());
        out.printf("  -p, --bind-port=<port>        %s\n", Messages.MSG.serverHelpBindPort(11222));
        out.printf("  -s, --server-root=<path>      %s\n", Messages.MSG.toolHelpServerRoot("server"));
        out.printf("  -v, --version                 %s\n", Messages.MSG.toolHelpVersion());
        out.printf("  -D<name>=<value>              %s\n", Messages.MSG.serverHelpProperty());
    }

    @Override
    public void version(PrintStream out) {
        out.printf("%s Server %s (%s)\n", Version.getBrandName(), Version.getVersion(), Version.getCodename());
        out.println("Copyright (C) Red Hat Inc. and/or its affiliates and other contributors");
        out.println("License Apache License, v. 2.0. http://www.apache.org/licenses/LICENSE-2.0");
    }

    private void logJVMInformation() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        Logger logger2 = Logger.getLogger("BOOT");
        logger2.info("JVM " + runtimeMxBean.getVmName() + " " + runtimeMxBean.getVmVendor() + " " + runtimeMxBean.getVmVersion());
        StringJoiner sj = new StringJoiner(" ");
        runtimeMxBean.getInputArguments().forEach(s -> sj.add((CharSequence)s));
        logger2.info("JVM arguments = " + sj);
        logger2.info("PID = " + runtimeMxBean.getName().split("@")[0]);
    }

    static {
        System.setProperty("log4j2.contextSelector", "org.apache.logging.log4j.core.selector.BasicContextSelector");
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
    }
}

