/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.server.configuration.security.LdapAttributeConfiguration;
import org.infinispan.server.configuration.security.LdapAttributeConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapAttributeMappingConfiguration;
import org.infinispan.server.configuration.security.LdapRealmConfigurationBuilder;

public class LdapAttributeMappingConfigurationBuilder
implements Builder<LdapAttributeMappingConfiguration> {
    private final List<LdapAttributeConfigurationBuilder> attributes = new ArrayList<LdapAttributeConfigurationBuilder>();
    private final LdapRealmConfigurationBuilder ldapConfigurationBuilder;

    LdapAttributeMappingConfigurationBuilder(LdapRealmConfigurationBuilder ldapConfigurationBuilder) {
        this.ldapConfigurationBuilder = ldapConfigurationBuilder;
    }

    public LdapAttributeConfigurationBuilder addAttribute() {
        LdapAttributeConfigurationBuilder attributeConfigurationBuilder = new LdapAttributeConfigurationBuilder(this.ldapConfigurationBuilder);
        this.attributes.add(attributeConfigurationBuilder);
        return attributeConfigurationBuilder;
    }

    public LdapAttributeMappingConfiguration create() {
        List<LdapAttributeConfiguration> attributesConfiguration = this.attributes.stream().map(LdapAttributeConfigurationBuilder::create).collect(Collectors.toList());
        return new LdapAttributeMappingConfiguration(attributesConfiguration);
    }

    public void validate() {
    }

    public LdapAttributeMappingConfigurationBuilder read(LdapAttributeMappingConfiguration template) {
        this.attributes.clear();
        template.attributesConfiguration().forEach(a -> this.addAttribute().read((LdapAttributeConfiguration)a));
        return this;
    }
}

