/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.security.Provider;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.time.DefaultTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.server.DefaultExitHandler;
import org.infinispan.server.ExitHandler;
import org.infinispan.server.ExitStatus;
import org.infinispan.server.Extensions;
import org.infinispan.server.SecurityActions;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.security.TokenRealmConfiguration;
import org.infinispan.server.core.CacheIgnoreManager;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.logging.Log;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;
import org.infinispan.server.router.router.impl.singleport.SinglePortEndpointRouter;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.infinispan.server.router.routes.hotrod.HotRodServerRouteDestination;
import org.infinispan.server.router.routes.rest.RestServerRouteDestination;
import org.infinispan.server.router.routes.singleport.SinglePortRouteSource;
import org.infinispan.server.tasks.admin.ServerAdminOperationsHandler;
import org.infinispan.tasks.TaskManager;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.logging.LogFactory;
import org.wildfly.security.http.basic.WildFlyElytronHttpBasicProvider;
import org.wildfly.security.http.bearer.WildFlyElytronHttpBearerProvider;
import org.wildfly.security.http.cert.WildFlyElytronHttpClientCertProvider;
import org.wildfly.security.http.digest.WildFlyElytronHttpDigestProvider;
import org.wildfly.security.http.spnego.WildFlyElytronHttpSpnegoProvider;
import org.wildfly.security.sasl.digest.WildFlyElytronSaslDigestProvider;
import org.wildfly.security.sasl.external.WildFlyElytronSaslExternalProvider;
import org.wildfly.security.sasl.gs2.WildFlyElytronSaslGs2Provider;
import org.wildfly.security.sasl.gssapi.WildFlyElytronSaslGssapiProvider;
import org.wildfly.security.sasl.localuser.WildFlyElytronSaslLocalUserProvider;
import org.wildfly.security.sasl.oauth2.WildFlyElytronSaslOAuth2Provider;
import org.wildfly.security.sasl.plain.WildFlyElytronSaslPlainProvider;
import org.wildfly.security.sasl.scram.WildFlyElytronSaslScramProvider;

public class Server
implements ServerManagement,
AutoCloseable {
    public static final Log log = (Log)LogFactory.getLog((String)"SERVER", Log.class);
    public static final String INFINISPAN_BIND_ADDRESS = "infinispan.bind.address";
    public static final String INFINISPAN_BIND_PORT = "infinispan.bind.port";
    public static final String INFINISPAN_CLUSTER_NAME = "infinispan.cluster.name";
    public static final String INFINISPAN_CLUSTER_STACK = "infinispan.cluster.stack";
    public static final String INFINISPAN_NODE_NAME = "infinispan.node.name";
    public static final String INFINISPAN_PORT_OFFSET = "infinispan.socket.binding.port-offset";
    public static final String JGROUPS_BIND_ADDRESS = "jgroups.bind.address";
    public static final String INFINISPAN_SERVER_HOME_PATH = "infinispan.server.home.path";
    public static final String INFINISPAN_SERVER_ROOT_PATH = "infinispan.server.root.path";
    public static final String INFINISPAN_SERVER_CONFIG_PATH = "infinispan.server.config.path";
    public static final String INFINISPAN_SERVER_DATA_PATH = "infinispan.server.data.path";
    public static final String INFINISPAN_SERVER_LOG_PATH = "infinispan.server.log.path";
    private static final String SERVER_DEFAULTS = "infinispan-defaults.xml";
    public static final String DEFAULT_SERVER_CONFIG = "conf";
    public static final String DEFAULT_SERVER_DATA = "data";
    public static final String DEFAULT_SERVER_LIB = "lib";
    public static final String DEFAULT_SERVER_LOG = "log";
    public static final String DEFAULT_SERVER_ROOT_DIR = "server";
    public static final String DEFAULT_SERVER_STATIC_DIR = "static";
    public static final String DEFAULT_CONFIGURATION_FILE = "infinispan.xml";
    public static final String DEFAULT_LOGGING_FILE = "log4j2.xml";
    public static final String DEFAULT_CLUSTER_NAME = "cluster";
    public static final String DEFAULT_CLUSTER_STACK = "tcp";
    public static final int DEFAULT_BIND_PORT = 11222;
    private static final int SHUTDOWN_DELAY_SECONDS = 3;
    private final TimeService timeService;
    private final File serverRoot;
    private final File serverConf;
    private final long startTime;
    private final Properties properties;
    private ExitHandler exitHandler = new DefaultExitHandler();
    private ConfigurationBuilderHolder defaultsHolder;
    private ConfigurationBuilderHolder configurationBuilderHolder;
    private Map<String, DefaultCacheManager> cacheManagers;
    private Map<String, ProtocolServer> protocolServers;
    private volatile ComponentStatus status;
    private ServerConfiguration serverConfiguration;
    private Extensions extensions;
    private CacheIgnoreManager cacheIgnoreManager;
    private ScheduledExecutorService scheduler;
    private TaskManager taskManager;

    public Server() {
        this(new File(DEFAULT_SERVER_ROOT_DIR), new File(DEFAULT_CONFIGURATION_FILE), SecurityActions.getSystemProperties());
    }

    public Server(File serverRoot, File configuration, Properties properties) {
        this(serverRoot, properties);
        if (!configuration.isAbsolute()) {
            configuration = new File(this.serverConf, configuration.getPath());
        }
        try {
            this.parseConfiguration(configuration.toURI().toURL());
        }
        catch (IOException e) {
            throw new CacheConfigurationException((Exception)e);
        }
    }

    private Server(File serverRoot, Properties properties) {
        this.timeService = DefaultTimeService.INSTANCE;
        this.startTime = this.timeService.time();
        this.serverRoot = serverRoot;
        this.properties = properties;
        this.status = ComponentStatus.INSTANTIATED;
        properties.putIfAbsent(INFINISPAN_SERVER_ROOT_PATH, serverRoot);
        properties.putIfAbsent(INFINISPAN_SERVER_CONFIG_PATH, new File(serverRoot, DEFAULT_SERVER_CONFIG).getAbsolutePath());
        properties.putIfAbsent(INFINISPAN_SERVER_DATA_PATH, new File(serverRoot, DEFAULT_SERVER_DATA).getAbsolutePath());
        properties.putIfAbsent(INFINISPAN_SERVER_LOG_PATH, new File(serverRoot, DEFAULT_SERVER_LOG).getAbsolutePath());
        properties.putIfAbsent(INFINISPAN_BIND_PORT, (Object)11222);
        properties.putIfAbsent(INFINISPAN_CLUSTER_NAME, DEFAULT_CLUSTER_NAME);
        properties.putIfAbsent(INFINISPAN_CLUSTER_STACK, DEFAULT_CLUSTER_STACK);
        this.serverConf = new File(properties.getProperty(INFINISPAN_SERVER_CONFIG_PATH));
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronHttpBasicProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronHttpBearerProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronHttpDigestProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronHttpClientCertProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronHttpSpnegoProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslPlainProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslDigestProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslScramProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslExternalProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslLocalUserProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslOAuth2Provider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslGssapiProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslGs2Provider.getInstance());
    }

    private void parseConfiguration(URL config) {
        ParserRegistry parser = new ParserRegistry(Thread.currentThread().getContextClassLoader(), false, this.properties);
        try {
            URL defaults = this.getClass().getClassLoader().getResource(SERVER_DEFAULTS);
            this.defaultsHolder = parser.parse(defaults);
            this.configurationBuilderHolder = new ConfigurationBuilderHolder();
            this.configurationBuilderHolder.getGlobalConfigurationBuilder().read(this.defaultsHolder.getGlobalConfigurationBuilder().build());
            for (Map.Entry entry : this.defaultsHolder.getNamedConfigurationBuilders().entrySet()) {
                this.configurationBuilderHolder.newConfigurationBuilder((String)entry.getKey()).read(((ConfigurationBuilder)entry.getValue()).build());
            }
            parser.parse(config, this.configurationBuilderHolder);
            log.tracef("Parsed cache configurations: %s", this.configurationBuilderHolder.getNamedConfigurationBuilders().keySet());
            ServerAdminOperationsHandler adminOperationsHandler = new ServerAdminOperationsHandler(this.defaultsHolder);
            ServerConfigurationBuilder serverConfigurationBuilder = (ServerConfigurationBuilder)this.configurationBuilderHolder.getGlobalConfigurationBuilder().module(ServerConfigurationBuilder.class);
            serverConfigurationBuilder.connectors().forEach(builder -> builder.adminOperationsHandler((AdminOperationsHandler)adminOperationsHandler));
            for (Map.Entry entry : this.configurationBuilderHolder.getNamedConfigurationBuilders().entrySet()) {
                Configuration cfg = ((ConfigurationBuilder)entry.getValue()).build();
                ConfigurationBuilder defaultCfg = (ConfigurationBuilder)this.defaultsHolder.getNamedConfigurationBuilders().get("org.infinispan." + cfg.clustering().cacheMode().name());
                ConfigurationBuilder rebased = new ConfigurationBuilder().read(defaultCfg.build());
                rebased.read(cfg);
                entry.setValue(rebased);
            }
            this.configurationBuilderHolder.validate();
        }
        catch (IOException | XMLStreamException e) {
            throw new CacheConfigurationException(e);
        }
    }

    public ExitHandler getExitHandler() {
        return this.exitHandler;
    }

    public void setExitHandler(ExitHandler exitHandler) {
        if (this.status != ComponentStatus.INSTANTIATED) {
            throw new IllegalStateException("Cannot change exit handler on a running server");
        }
        this.exitHandler = exitHandler;
    }

    public synchronized CompletableFuture<ExitStatus> run() {
        CompletionStage<ExitStatus> r = this.exitHandler.getExitFuture();
        if (this.status == ComponentStatus.RUNNING) {
            return r;
        }
        this.cacheManagers = new LinkedHashMap<String, DefaultCacheManager>(2);
        this.protocolServers = new ConcurrentHashMap<String, ProtocolServer>(4);
        try {
            this.extensions = new Extensions();
            this.extensions.load(Thread.currentThread().getContextClassLoader());
            DefaultCacheManager cm = new DefaultCacheManager(this.configurationBuilderHolder, false);
            this.cacheManagers.put(cm.getName(), cm);
            SecurityActions.startCacheManager((EmbeddedCacheManager)cm);
            BasicComponentRegistry bcr = (BasicComponentRegistry)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cm).getComponent(BasicComponentRegistry.class.getName());
            this.cacheIgnoreManager = (CacheIgnoreManager)bcr.getComponent(CacheIgnoreManager.class).running();
            this.taskManager = (TaskManager)bcr.getComponent(TaskManager.class).running();
            this.taskManager.registerTaskEngine(this.extensions.getServerTaskEngine((EmbeddedCacheManager)cm));
            this.serverConfiguration = (ServerConfiguration)SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)cm).module(ServerConfiguration.class);
            this.serverConfiguration.setServer(this);
            SinglePortRouteSource routeSource = new SinglePortRouteSource();
            ConcurrentHashMap routes = new ConcurrentHashMap();
            this.serverConfiguration.endpoints().connectors().parallelStream().forEach(configuration -> {
                try {
                    Class<ProtocolServer> protocolServerClass = configuration.getClass().getAnnotation(ConfigurationFor.class).value().asSubclass(ProtocolServer.class);
                    ProtocolServer protocolServer = (ProtocolServer)Util.getInstance(protocolServerClass);
                    if (protocolServer instanceof RestServer) {
                        ((RestServer)protocolServer).setServer((ServerManagement)this);
                    }
                    this.protocolServers.put(protocolServer.getName() + "-" + configuration.name(), protocolServer);
                    SecurityActions.startProtocolServer((ProtocolServer<ProtocolServerConfiguration>)protocolServer, configuration, (EmbeddedCacheManager)cm);
                    ProtocolServerConfiguration protocolConfig = protocolServer.getConfiguration();
                    if (protocolConfig.startTransport()) {
                        log.protocolStarted(protocolServer.getName(), protocolConfig.host(), protocolConfig.port());
                    } else {
                        if (protocolServer instanceof HotRodServer) {
                            routes.put(new Route((RouteSource)routeSource, (RouteDestination)new HotRodServerRouteDestination(protocolServer.getName(), (HotRodServer)protocolServer)), 0);
                            this.extensions.apply((HotRodServer)protocolServer);
                        } else if (protocolServer instanceof RestServer) {
                            routes.put(new Route((RouteSource)routeSource, (RouteDestination)new RestServerRouteDestination(protocolServer.getName(), (RestServer)protocolServer)), 0);
                        }
                        log.protocolStarted(protocolServer.getName());
                    }
                }
                catch (Throwable t) {
                    System.err.println(t.getMessage());
                    t.printStackTrace();
                }
            });
            SinglePortRouterConfiguration singlePortRouter = this.serverConfiguration.endpoints().singlePortRouter();
            SinglePortEndpointRouter endpointServer = new SinglePortEndpointRouter(singlePortRouter);
            endpointServer.start(new RoutingTable(routes.keySet()));
            this.protocolServers.put("endpoint", (ProtocolServer)endpointServer);
            log.protocolStarted(endpointServer.getName(), singlePortRouter.host(), singlePortRouter.port());
            log.endpointUrl(Util.requireNonNullElse((Object)cm.getAddress(), (Object)"local"), singlePortRouter.ssl().enabled() ? "https" : "http", singlePortRouter.host(), singlePortRouter.port());
            this.status = ComponentStatus.RUNNING;
            log.serverStarted(Version.getBrandName(), Version.getVersion(), this.timeService.timeDuration(this.startTime, TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            r.completeExceptionally(e);
        }
        r = r.whenComplete((status, t) -> this.localShutdown((ExitStatus)status));
        return r;
    }

    public ConfigurationInfo getConfiguration() {
        return this.serverConfiguration;
    }

    public Map<String, String> getLoginConfiguration() {
        HashMap<String, String> loginConfiguration = new HashMap<String, String>();
        RestServerConfiguration rest = (RestServerConfiguration)this.serverConfiguration.endpoints().connectors().stream().filter(p -> p instanceof RestServerConfiguration).findFirst().get();
        if (rest.authentication().mechanisms().contains("BEARER_TOKEN")) {
            TokenRealmConfiguration realmConfiguration = this.serverConfiguration.security().realms().realms().get(0).tokenConfiguration();
            loginConfiguration.put("mode", "OIDC");
            loginConfiguration.put("url", realmConfiguration.authServerUrl());
            loginConfiguration.put("realm", realmConfiguration.name());
            loginConfiguration.put("clientId", realmConfiguration.oauth2Configuration().clientId());
        } else {
            loginConfiguration.put("mode", "HTTP");
        }
        return loginConfiguration;
    }

    public void serverStop(List<String> servers) {
        for (DefaultCacheManager cacheManager : this.cacheManagers.values()) {
            ClusterExecutor executor = cacheManager.executor();
            if (servers != null && !servers.isEmpty()) {
                List targets = cacheManager.getMembers().stream().filter(a -> servers.contains(a.toString())).collect(Collectors.toList());
                executor = executor.filterTargets(targets);
                this.sendExitStatusToServers(executor, ExitStatus.SERVER_SHUTDOWN);
                continue;
            }
            this.serverStopHandler(ExitStatus.SERVER_SHUTDOWN);
        }
    }

    public void clusterStop() {
        this.cacheManagers.values().forEach(cm -> {
            cm.getCacheNames().forEach(name -> SecurityActions.shutdownCache((EmbeddedCacheManager)cm, name));
            this.sendExitStatusToServers(cm.executor(), ExitStatus.CLUSTER_SHUTDOWN);
        });
    }

    private void sendExitStatusToServers(ClusterExecutor clusterExecutor, ExitStatus exitStatus) {
        CompletableFuture job = clusterExecutor.submitConsumer((SerializableFunction)new ShutdownRunnable(exitStatus), (a, i, t) -> {
            if (t != null) {
                log.clusteredTaskError((Throwable)t);
            }
        });
        job.join();
    }

    private void localShutdown(ExitStatus exitStatus) {
        this.status = ComponentStatus.STOPPING;
        if (exitStatus == ExitStatus.CLUSTER_SHUTDOWN) {
            log.clusterShutdown();
        }
        this.protocolServers.values().parallelStream().forEach(ProtocolServer::stop);
        this.cacheManagers.values().forEach(cm -> SecurityActions.stopCacheManager((EmbeddedCacheManager)cm));
        this.status = ComponentStatus.TERMINATED;
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    private void serverStopHandler(ExitStatus exitStatus) {
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.schedule(() -> this.getExitHandler().exit(exitStatus), 3L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    public Set<String> cacheManagerNames() {
        return this.cacheManagers.keySet();
    }

    public DefaultCacheManager getCacheManager(String name) {
        return this.cacheManagers.get(name);
    }

    public CacheIgnoreManager getIgnoreManager(String cacheManager) {
        return this.cacheIgnoreManager;
    }

    public ConfigurationBuilderHolder getConfigurationBuilderHolder() {
        return this.configurationBuilderHolder;
    }

    public File getServerRoot() {
        return this.serverRoot;
    }

    public Map<String, DefaultCacheManager> getCacheManagers() {
        return this.cacheManagers;
    }

    public Map<String, ProtocolServer> getProtocolServers() {
        return this.protocolServers;
    }

    public ComponentStatus getStatus() {
        return this.status;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    @SerializeWith(value=Externalizer.class)
    static final class ShutdownRunnable
    implements SerializableFunction<EmbeddedCacheManager, Void> {
        private final ExitStatus exitStatus;

        ShutdownRunnable(ExitStatus exitStatus) {
            this.exitStatus = exitStatus;
        }

        public Void apply(EmbeddedCacheManager em) {
            Server server = ((ServerConfiguration)SecurityActions.getCacheManagerConfiguration(em).module(ServerConfiguration.class)).getServer();
            server.serverStopHandler(this.exitStatus);
            return null;
        }

        public static class Externalizer
        implements org.infinispan.commons.marshall.Externalizer<ShutdownRunnable> {
            public void writeObject(ObjectOutput output, ShutdownRunnable object) throws IOException {
                output.writeObject(object.exitStatus);
            }

            public ShutdownRunnable readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                ExitStatus exitStatus = (ExitStatus)input.readObject();
                return new ShutdownRunnable(exitStatus);
            }
        }
    }
}

