/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.logging;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.infinispan.commons.CacheConfigurationException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%s Server starting", id=80000)
    public void serverStarting(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%s Server %s started in %dms", id=80001)
    public void serverStarted(String var1, String var2, long var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%s Server stopping", id=80002)
    public void serverStopping(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%s Server stopped", id=80003)
    public void serverStopped(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Protocol %s listening on %s:%d", id=80004)
    public void protocolStarted(String var1, String var2, int var3);

    @Message(value="Cannot instantiate protocol server configuration '%s'", id=80008)
    public CacheConfigurationException cannotInstantiateProtocolServerConfigurationBuilder(Class<?> var1, @Cause Exception var2);

    @Message(value="Unknown interface '%s'", id=80009)
    public CacheConfigurationException unknownInterface(String var1);

    @Message(value="Unknown socket binding '%s'", id=80010)
    public CacheConfigurationException unknownSocketBinding(String var1);

    @Message(value="Unknown security domain '%s'", id=80014)
    public CacheConfigurationException unknownSecurityDomain(String var1);

    @Message(value="Unable to load realm property files", id=80015)
    public CacheConfigurationException unableToLoadRealmPropertyFiles(@Cause IOException var1);

    @Message(value="No default key manager available", id=80016)
    public NoSuchAlgorithmException noDefaultKeyManager();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Server configuration: %s", id=80017)
    public void serverConfiguration(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Protocol %s (internal)", id=80018)
    public void protocolStarted(String var1);

    @Message(value="Cannot use a trust store without a server identity", id=80020)
    public CacheConfigurationException trustStoreWithoutServerIdentity();

    @Message(value="Authentication cannot be configured without a security realm", id=80021)
    public CacheConfigurationException authenticationWithoutSecurityRealm();

    @Message(value="Cannot configure protocol encryption under a single port endpoint. Use a dedicated socket binding.", id=80022)
    public CacheConfigurationException cannotConfigureProtocolEncryptionUnderSinglePort();

    @Message(value="Cannot configure a protocol with the same socket binding used by the endpoint. Use a dedicated socket binding.", id=80023)
    public CacheConfigurationException protocolCannotUseSameSocketBindingAsEndpoint();

    @Message(value="Invalid URL", id=80024)
    public CacheConfigurationException invalidUrl();

    @Message(value="Cannot have multiple connectors of the same type: found [%s]", id=80025)
    public CacheConfigurationException multipleEndpointsSameTypeFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Extension factory '%s' is lacking a @NamedFactory annotation", id=80026)
    public void unnamedFactoryClass(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Loaded extension '%s'", id=80027)
    public void loadedExtension(String var1);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(value="%s Server failed to start", id=80028)
    public void serverFailedToStart(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Cluster shutdown", id=80029)
    public void clusterShutdown();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Clustered task error", id=80030)
    public void clusteredTaskError(@Cause Throwable var1);

    @Message(value="Unknown server identity '%s'", id=80031)
    public IllegalArgumentException unknownServerIdentity(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Logging configuration: %s", id=80032)
    public void loggingConfiguration(String var1);

    @Message(value="Cannot find a network address which matches the supplied configuration", id=80033)
    public CacheConfigurationException invalidNetworkConfiguration();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Server '%s' listening on %s://%s:%d", id=80034)
    public void endpointUrl(Object var1, String var2, String var3, int var4);

    @Message(value="Unknown appender `%s`", id=80035)
    public IllegalArgumentException unknownAppender(String var1);

    @Message(value="Invalid level `%s`", id=80036)
    public IllegalArgumentException invalidLevel(String var1);

    @Message(value="The name '%s' is already bound", id=80037)
    public NamingException nameAlreadyBound(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Created datasource '%s' bound to JNDI '%s'", id=80038)
    public void dataSourceCreated(String var1, String var2);

    @Message(value="Cannot find InitialContextFactory '%s'", id=80039)
    public NoInitialContextException noInitialContextFactory(String var1);
}

