/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.io.File;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.GroupsPropertiesConfigurationBuilder;
import org.infinispan.server.configuration.security.PropertiesRealmConfiguration;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.UserPropertiesConfigurationBuilder;
import org.infinispan.server.security.ServerSecurityRealm;
import org.infinispan.server.security.realm.PropertiesSecurityRealm;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;

public class PropertiesRealmConfigurationBuilder
implements Builder<PropertiesRealmConfiguration> {
    private final UserPropertiesConfigurationBuilder userProperties = new UserPropertiesConfigurationBuilder();
    private final GroupsPropertiesConfigurationBuilder groupProperties = new GroupsPropertiesConfigurationBuilder();
    private final AttributeSet attributes;
    private final RealmConfigurationBuilder realmBuilder;
    private PropertiesSecurityRealm securityRealm;

    PropertiesRealmConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.realmBuilder = realmBuilder;
        this.attributes = PropertiesRealmConfiguration.attributeDefinitionSet();
    }

    public PropertiesRealmConfigurationBuilder groupAttribute(String groupAttribute) {
        this.attributes.attribute(PropertiesRealmConfiguration.GROUPS_ATTRIBUTE).set((Object)groupAttribute);
        return this;
    }

    public UserPropertiesConfigurationBuilder userProperties() {
        return this.userProperties;
    }

    public GroupsPropertiesConfigurationBuilder groupProperties() {
        return this.groupProperties;
    }

    public void validate() {
        this.userProperties.validate();
        this.groupProperties.validate();
    }

    public PropertiesSecurityRealm build() {
        if (this.securityRealm == null && this.attributes.isModified()) {
            File usersFile = this.userProperties.getFile();
            File groupsFile = this.groupProperties.getFile();
            String groupsAttribute = (String)this.attributes.attribute(PropertiesRealmConfiguration.GROUPS_ATTRIBUTE).get();
            boolean plainText = this.userProperties.plainText();
            String realmName = this.userProperties.digestRealmName();
            PropertiesSecurityRealm propertiesSecurityRealm = new PropertiesSecurityRealm(usersFile, groupsFile, plainText, groupsAttribute, realmName);
            SecurityDomain.Builder domainBuilder = this.realmBuilder.domainBuilder();
            domainBuilder.addRealm(realmName, (SecurityRealm)propertiesSecurityRealm).build();
            if (domainBuilder.getDefaultRealmName() == null) {
                domainBuilder.setDefaultRealmName(realmName);
            }
            this.securityRealm = propertiesSecurityRealm;
            this.realmBuilder.setHttpChallengeReadiness(propertiesSecurityRealm::isEmpty);
            this.realmBuilder.addFeature(ServerSecurityRealm.Feature.PASSWORD);
        }
        return this.securityRealm;
    }

    public PropertiesRealmConfiguration create() {
        return new PropertiesRealmConfiguration(this.attributes.protect(), this.userProperties.create(), this.groupProperties.create());
    }

    public PropertiesRealmConfigurationBuilder read(PropertiesRealmConfiguration template) {
        this.attributes.read(template.attributes());
        this.userProperties.read(template.userProperties());
        this.groupProperties.read(template.groupProperties());
        return this;
    }
}

