/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.infinispan.commons.util.Version;
import org.infinispan.server.logging.Messages;
import org.infinispan.server.security.SecurityActions;
import org.infinispan.server.tool.Main;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.spec.BasicPasswordSpecEncoding;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;

public class UserTool
extends Main {
    public static final String DEFAULT_USERS_PROPERTIES_FILE = "users.properties";
    public static final String DEFAULT_GROUPS_PROPERTIES_FILE = "groups.properties";
    public static final String DEFAULT_REALM_NAME = "default";
    private static final List<String> DEFAULT_ALGORITHMS = Arrays.asList("scram-sha-1", "scram-sha-256", "scram-sha-384", "scram-sha-512", "digest-md5", "digest-sha", "digest-sha-256", "digest-sha-384", "digest-sha-512");
    private String username = null;
    private String password = null;
    private String realm = "default";
    private String usersFileName = "users.properties";
    private String groupsFileName = "groups.properties";
    private List<String> addGroups = new ArrayList<String>();
    private List<String> algorithms = DEFAULT_ALGORITHMS;
    private boolean batchMode = false;
    private boolean plainText = false;

    public static void main(String ... args) {
        UserTool userTool = new UserTool();
        userTool.run(args);
    }

    public UserTool() {
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronPasswordProvider.getInstance());
    }

    @Override
    protected void handleArgumentCommand(String command, String parameter, Iterator<String> args) {
        switch (command) {
            case "-a": {
                parameter = args.next();
            }
            case "--algorithms": {
                this.algorithms = Arrays.stream(parameter.split(",")).collect(Collectors.toList());
                break;
            }
            case "-b": 
            case "--batch-mode": {
                this.batchMode = true;
                break;
            }
            case "-f": {
                parameter = args.next();
            }
            case "--users-file": {
                this.usersFileName = parameter;
                break;
            }
            case "-p": {
                parameter = args.next();
            }
            case "--password": {
                this.password = parameter;
                break;
            }
            case "-c": 
            case "--clear-text": {
                this.plainText = true;
                break;
            }
            case "-e": 
            case "--encrypted": {
                this.plainText = false;
                break;
            }
            case "-g": {
                parameter = args.next();
            }
            case "--groups": {
                for (String group : parameter.split(",")) {
                    this.addGroups.add(group);
                }
                break;
            }
            case "-w": {
                parameter = args.next();
            }
            case "--groups-file": {
                this.groupsFileName = parameter;
                break;
            }
            case "-r": {
                parameter = args.next();
            }
            case "--realm": {
                this.realm = parameter;
                break;
            }
            case "-s": {
                parameter = args.next();
            }
            case "--server-root": {
                this.serverRoot = new File(parameter);
                break;
            }
            case "-u": {
                parameter = args.next();
            }
            case "--user": {
                this.username = parameter;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    protected void runInternal() {
        FileWriter writer;
        while (this.username == null || this.username.isEmpty()) {
            this.username = System.console().readLine(Messages.MSG.userToolUsername(), new Object[0]);
        }
        File confDir = new File(this.serverRoot, "conf");
        Properties users = new Properties();
        File usersFile = new File(confDir, this.usersFileName);
        if (usersFile.exists()) {
            try (FileReader reader = new FileReader(usersFile);){
                users.load(reader);
            }
            catch (IOException e) {
                throw Messages.MSG.userToolIOError(usersFile, e);
            }
        }
        Properties groups = new Properties();
        File groupsFile = new File(confDir, this.groupsFileName);
        if (groupsFile.exists()) {
            try (FileReader reader = new FileReader(groupsFile);){
                groups.load(reader);
            }
            catch (IOException e) {
                throw Messages.MSG.userToolIOError(groupsFile, e);
            }
        }
        if (!this.batchMode && users.containsKey(this.username)) {
            String answer;
            while (!"Y".equalsIgnoreCase(answer = System.console().readLine(Messages.MSG.userToolUserExists(this.username), new Object[0])) && !"N".equalsIgnoreCase(answer)) {
            }
            if ("N".equalsIgnoreCase(answer)) {
                this.exit(0);
            }
        }
        if (this.password == null) {
            if (!this.batchMode) {
                while (true) {
                    if (this.password == null || this.password.isEmpty()) {
                        this.password = new String(System.console().readPassword(Messages.MSG.userToolPassword(), new Object[0]));
                        continue;
                    }
                    String confirm = new String(System.console().readPassword(Messages.MSG.userToolPasswordConfirm(), new Object[0]));
                    if (!this.password.equals(confirm)) {
                        this.password = null;
                    }
                    if (this.password != null) break;
                }
            } else {
                this.stdErr.println(Messages.MSG.userToolNoPassword(this.username));
                this.exit(1);
            }
        }
        users.put(this.username, this.plainText ? this.password : this.encryptPassword(this.username, this.realm, this.password));
        groups.put(this.username, String.join((CharSequence)",", this.addGroups));
        try {
            writer = new FileWriter(usersFile);
            try {
                String algorithm = this.plainText ? "clear" : "encrypted";
                users.store(writer, "$REALM_NAME=" + this.realm + "$\n$ALGORITHM=" + algorithm + "$");
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw Messages.MSG.userToolIOError(usersFile, e);
        }
        try {
            writer = new FileWriter(groupsFile);
            try {
                groups.store(writer, null);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw Messages.MSG.userToolIOError(groupsFile, e);
        }
    }

    private String encryptPassword(String username, String realm, String password) {
        try {
            StringBuilder sb = new StringBuilder();
            for (String algorithm : this.algorithms) {
                DigestPasswordAlgorithmSpec spec;
                PasswordFactory passwordFactory = PasswordFactory.getInstance((String)algorithm);
                sb.append(algorithm);
                sb.append(":");
                switch (algorithm) {
                    case "scram-sha-1": 
                    case "scram-sha-256": 
                    case "scram-sha-384": 
                    case "scram-sha-512": {
                        spec = new IteratedSaltedPasswordAlgorithmSpec(20000, UserTool.salt(12));
                        break;
                    }
                    case "digest-md5": 
                    case "digest-sha": 
                    case "digest-sha-256": 
                    case "digest-sha-384": 
                    case "digest-sha-512": {
                        spec = new DigestPasswordAlgorithmSpec(username, realm);
                        break;
                    }
                    default: {
                        throw Messages.MSG.userToolUnknownAlgorithm(algorithm);
                    }
                }
                Password encrypted = passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(password.toCharArray(), (AlgorithmParameterSpec)spec));
                byte[] encoded = BasicPasswordSpecEncoding.encode((Password)encrypted);
                sb.append(ByteIterator.ofBytes((byte[])encoded).base64Encode().drainToString());
                sb.append(";");
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] salt(int size) {
        byte[] salt = new byte[size];
        ThreadLocalRandom.current().nextBytes(salt);
        return salt;
    }

    @Override
    public void help(PrintStream out) {
        out.printf("Usage:\n", new Object[0]);
        out.printf("  -u, --user=<name>                  %s\n", Messages.MSG.userToolHelpUser());
        out.printf("  -p, --password=<password>          %s\n", Messages.MSG.userToolHelpPassword());
        out.printf("  -c, --clear-text                   %s\n", Messages.MSG.userToolHelpClearTextPassword());
        out.printf("  -a, --algorithms=<algorithms>      %s\n", Messages.MSG.userToolHelpAlgorithms(DEFAULT_ALGORITHMS));
        out.printf("  -e, --encrypted                    %s\n", Messages.MSG.userToolHelpEncryptedPassword());
        out.printf("  -g, --groups=<group1[,group2...]>  %s\n", Messages.MSG.userToolHelpGroups());
        out.printf("  -f, --users-file=<file>            %s\n", Messages.MSG.userToolHelpUsersFile(DEFAULT_USERS_PROPERTIES_FILE));
        out.printf("  -w, --groups-file=<file>           %s\n", Messages.MSG.userToolHelpGroupsFile(DEFAULT_GROUPS_PROPERTIES_FILE));
        out.printf("  -r, --realm=<realm>                %s\n", Messages.MSG.userToolHelpRealm(DEFAULT_REALM_NAME));
        out.printf("  -s, --server-root=<path>           %s\n", Messages.MSG.toolHelpServerRoot("server"));
        out.printf("  -b, --batch-mode                   %s\n", Messages.MSG.userToolHelpBatchMode());
        out.printf("  -h, --help                         %s\n", Messages.MSG.toolHelpHelp());
        out.printf("  -v, --version                      %s\n", Messages.MSG.toolHelpVersion());
    }

    @Override
    public void version(PrintStream out) {
        out.printf("%s User Tool %s (%s)\n", Version.getBrandName(), Version.getVersion(), Version.getCodename());
        out.println("Copyright (C) Red Hat Inc. and/or its affiliates and other contributors");
        out.println("License Apache License, v. 2.0. http://www.apache.org/licenses/LICENSE-2.0");
    }
}

