/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.io.OutputStream;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.RestResponseException;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerResponse;

public class HttpServerResponseAdapter
implements HttpServerResponse {
    private final NettyRestResponse.Builder builder;

    private HttpServerResponseAdapter(NettyRestResponse.Builder responseBuilder) {
        this.builder = responseBuilder;
    }

    public static NettyRestResponse adapt(HttpServerMechanismsResponder responder, NettyRestResponse.Builder responseBuilder) {
        try {
            HttpServerResponseAdapter response = new HttpServerResponseAdapter(responseBuilder);
            if (responder != null) {
                responder.sendResponse((HttpServerResponse)response);
            }
            return response.builder.build();
        }
        catch (HttpAuthenticationException e) {
            throw new RestResponseException((Throwable)e);
        }
    }

    public void addResponseHeader(String headerName, String headerValue) {
        this.builder.header(headerName, (Object)headerValue);
    }

    public void setStatusCode(int statusCode) {
        this.builder.status(statusCode);
    }

    public void setResponseCookie(HttpServerCookie cookie) {
        StringBuilder value = new StringBuilder();
        value.append(cookie.getName());
        value.append('=');
        value.append(cookie.getValue());
        if (cookie.isHttpOnly()) {
            value.append("; HttpOnly");
        }
        if (cookie.isSecure()) {
            value.append("; Secure");
        }
        if (cookie.getDomain() != null) {
            value.append("; Domain=").append(cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            value.append("; Path=").append(cookie.getPath());
        }
        this.builder.header("Set-Cookie", (Object)value.toString());
    }

    public OutputStream getOutputStream() {
        return null;
    }

    public boolean forward(String path) {
        return false;
    }
}

