/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.tasks.admin;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;
import org.infinispan.security.impl.AuthorizationHelper;

final class SecurityActions {
    private SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return (T)(System.getSecurityManager() != null ? AccessController.doPrivileged(action) : Security.doPrivileged(action));
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        return (GlobalComponentRegistry)SecurityActions.doPrivileged(new GetGlobalComponentRegistryAction(cacheManager));
    }

    static void checkPermission(EmbeddedCacheManager cacheManager, AuthorizationPermission permission) {
        AuthorizationHelper authzHelper = (AuthorizationHelper)SecurityActions.getGlobalComponentRegistry(cacheManager).getComponent(AuthorizationHelper.class);
        authzHelper.checkPermission(Security.getSubject(), permission);
    }
}

