/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.LdapRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapUserPasswordMapperConfiguration;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;

public class LdapUserPasswordMapperConfigurationBuilder
implements Builder<LdapUserPasswordMapperConfiguration> {
    private final AttributeSet attributes = LdapUserPasswordMapperConfiguration.attributeDefinitionSet();
    private final LdapSecurityRealmBuilder.UserPasswordCredentialLoaderBuilder credentialLoaderBuilder;

    LdapUserPasswordMapperConfigurationBuilder(LdapRealmConfigurationBuilder ldapConfigurationBuilder) {
        this.credentialLoaderBuilder = ldapConfigurationBuilder.getLdapRealmBuilder().userPasswordCredentialLoader();
    }

    public LdapUserPasswordMapperConfigurationBuilder from(String from) {
        this.attributes.attribute(LdapUserPasswordMapperConfiguration.FROM).set((Object)from);
        this.credentialLoaderBuilder.setUserPasswordAttribute(from);
        return this;
    }

    public LdapUserPasswordMapperConfigurationBuilder verifiable(boolean verifiable) {
        this.attributes.attribute(LdapUserPasswordMapperConfiguration.VERIFIABLE).set((Object)verifiable);
        if (!verifiable) {
            this.credentialLoaderBuilder.disableVerification();
        }
        return this;
    }

    public LdapUserPasswordMapperConfigurationBuilder writable(boolean writable) {
        this.attributes.attribute(LdapUserPasswordMapperConfiguration.WRITABLE).set((Object)writable);
        if (writable) {
            this.credentialLoaderBuilder.enablePersistence();
        }
        return this;
    }

    public void validate() {
    }

    public void build() {
        this.credentialLoaderBuilder.build();
    }

    public LdapUserPasswordMapperConfiguration create() {
        return new LdapUserPasswordMapperConfiguration(this.attributes.protect());
    }

    public LdapUserPasswordMapperConfigurationBuilder read(LdapUserPasswordMapperConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

