/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.server.configuration.security.KeyStoreConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.SSLConfiguration;
import org.infinispan.server.configuration.security.SSLEngineConfigurationBuilder;

public class SSLConfigurationBuilder
implements Builder<SSLConfiguration> {
    private final KeyStoreConfigurationBuilder keyStore;
    private final SSLEngineConfigurationBuilder engine;

    SSLConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.keyStore = new KeyStoreConfigurationBuilder(realmBuilder);
        this.engine = new SSLEngineConfigurationBuilder(realmBuilder);
    }

    public KeyStoreConfigurationBuilder keyStore() {
        return this.keyStore;
    }

    public SSLEngineConfigurationBuilder engine() {
        return this.engine;
    }

    public void validate() {
    }

    public SSLConfiguration create() {
        return new SSLConfiguration(this.keyStore.create(), this.engine.create());
    }

    public SSLConfigurationBuilder read(SSLConfiguration template) {
        this.keyStore.read(template.keyStore());
        this.engine.read(template.engine());
        return this;
    }
}

