/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.server.security.HttpServerRequestAdapter;
import org.infinispan.server.security.RolePrincipal;
import org.infinispan.server.security.ServerSecurityRealm;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.http.HttpAuthenticationFactory;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.digest.DigestMechanismFactory;
import org.wildfly.security.http.util.SecurityProviderServerMechanismFactory;
import org.wildfly.security.http.util.SetMechanismInformationMechanismFactory;

public class ElytronHTTPAuthenticator
implements Authenticator {
    private final HttpAuthenticationFactory factory;
    private final ServerSecurityRealm serverSecurityRealm;
    private Executor executor;
    private RestServerConfiguration configuration;

    public ElytronHTTPAuthenticator(String name, ServerSecurityRealm realm, String serverPrincipal) {
        this.serverSecurityRealm = realm;
        HttpAuthenticationFactory.Builder httpBuilder = HttpAuthenticationFactory.builder();
        httpBuilder.setSecurityDomain(realm.getSecurityDomain());
        SecurityProviderServerMechanismFactory httpServerFactory = new SecurityProviderServerMechanismFactory();
        httpServerFactory = new SetMechanismInformationMechanismFactory((HttpServerAuthenticationMechanismFactory)httpServerFactory);
        httpBuilder.setFactory((HttpServerAuthenticationMechanismFactory)httpServerFactory);
        MechanismConfiguration.Builder mechConfigurationBuilder = MechanismConfiguration.builder();
        realm.applyServerCredentials(mechConfigurationBuilder, serverPrincipal);
        MechanismRealmConfiguration.Builder mechRealmBuilder = MechanismRealmConfiguration.builder();
        mechRealmBuilder.setRealmName(name);
        mechConfigurationBuilder.addMechanismRealm(mechRealmBuilder.build());
        httpBuilder.setMechanismConfigurationSelector(MechanismConfigurationSelector.constantSelector((MechanismConfiguration)mechConfigurationBuilder.build()));
        this.factory = httpBuilder.build();
    }

    public CompletionStage<RestResponse> challenge(RestRequest request, ChannelHandlerContext ctx) {
        HttpServerRequestAdapter requestAdapter = new HttpServerRequestAdapter(request, ctx);
        return CompletableFuture.supplyAsync(() -> {
            try {
                String authorizationHeader = request.getAuthorizationHeader();
                if (authorizationHeader == null) {
                    for (String name : this.configuration.authentication().mechanisms()) {
                        HttpServerAuthenticationMechanism mechanism = (HttpServerAuthenticationMechanism)this.factory.createMechanism(name);
                        mechanism.evaluateRequest((HttpServerRequest)requestAdapter);
                    }
                    return requestAdapter.getResponse();
                }
                String mechName = authorizationHeader.substring(0, authorizationHeader.indexOf(32)).toUpperCase();
                if ("BEARER".equals(mechName)) {
                    mechName = "BEARER_TOKEN";
                } else if ("NEGOTIATE".equals(mechName)) {
                    mechName = "SPNEGO";
                }
                HttpServerAuthenticationMechanism mechanism = (HttpServerAuthenticationMechanism)this.factory.createMechanism(mechName);
                mechanism.evaluateRequest((HttpServerRequest)requestAdapter);
                SecurityIdentity securityIdentity = (SecurityIdentity)mechanism.getNegotiatedProperty("wildfly.http.security-identity");
                if (securityIdentity != null) {
                    Subject subject = new Subject();
                    subject.getPrincipals().add(securityIdentity.getPrincipal());
                    securityIdentity.getRoles().forEach(r -> subject.getPrincipals().add(new RolePrincipal((String)r)));
                    request.setSubject(subject);
                }
                return requestAdapter.getResponse();
            }
            catch (HttpAuthenticationException e) {
                return new NettyRestResponse.Builder().status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
            }
        }, this.executor);
    }

    public void init(RestServer restServer) {
        this.configuration = (RestServerConfiguration)restServer.getConfiguration();
        this.executor = restServer.getExecutor();
        for (String name : this.configuration.authentication().mechanisms()) {
            try {
                this.factory.createMechanism(name);
            }
            catch (HttpAuthenticationException e) {
                throw new CacheConfigurationException("Could not create HTTP authentication mechanism " + name);
            }
        }
    }

    public boolean isReadyForHttpChallenge() {
        return this.serverSecurityRealm.isReadyForHttpChallenge();
    }

    public void close() {
        if (!Boolean.getBoolean("infinispan.security.elytron.skipnonceshutdown")) {
            new DigestMechanismFactory().shutdown();
        }
        this.factory.shutdownAuthenticationMechanismFactory();
    }
}

