/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.io.File;
import java.nio.file.Path;
import java.util.Properties;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.FileSystemRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.RealmProvider;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;

@BuiltBy(value=FileSystemRealmConfigurationBuilder.class)
public class FileSystemRealmConfiguration
extends ConfigurationElement<FileSystemRealmConfiguration>
implements RealmProvider {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((Enum)Attribute.NAME, (Object)"filesystem", String.class).build();
    static final AttributeDefinition<String> PATH = AttributeDefinition.builder((Enum)Attribute.PATH, null, String.class).build();
    static final AttributeDefinition<String> RELATIVE_TO = AttributeDefinition.builder((Enum)Attribute.RELATIVE_TO, (Object)"infinispan.server.config.path", String.class).autoPersist(false).build();
    static final AttributeDefinition<Integer> LEVELS = AttributeDefinition.builder((Enum)Attribute.LEVELS, null, Integer.class).build();
    static final AttributeDefinition<Boolean> ENCODED = AttributeDefinition.builder((Enum)Attribute.ENCODED, null, Boolean.class).build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(FileSystemRealmConfiguration.class, new AttributeDefinition[]{NAME, PATH, RELATIVE_TO, LEVELS, ENCODED});
    }

    FileSystemRealmConfiguration(AttributeSet attributes) {
        super((Enum)Element.FILESYSTEM_REALM, attributes, new ConfigurationElement[0]);
    }

    @Override
    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    @Override
    public SecurityRealm build(SecurityConfiguration securityConfiguration, RealmConfiguration realm, SecurityDomain.Builder domainBuilder, Properties properties) {
        String path = (String)this.attributes.attribute(PATH).get();
        String relativeTo = properties.getProperty((String)this.attributes.attribute(RELATIVE_TO).get());
        Integer levels = (Integer)this.attributes.attribute(LEVELS).get();
        Boolean encoded = (Boolean)this.attributes.attribute(ENCODED).get();
        Path filesystemPath = new File(ParseUtils.resolvePath((String)path, (String)relativeTo)).toPath();
        return new FileSystemSecurityRealm(filesystemPath, NameRewriter.IDENTITY_REWRITER, levels.intValue(), encoded.booleanValue());
    }
}

