/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.function.Supplier;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.InstanceSupplier;
import org.infinispan.server.configuration.security.LdapIdentityMappingConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapRealmConfiguration;
import org.infinispan.server.configuration.security.RealmProviderBuilder;
import org.wildfly.security.auth.realm.ldap.DirContextFactory;
import org.wildfly.security.auth.server.NameRewriter;

public class LdapRealmConfigurationBuilder
implements RealmProviderBuilder<LdapRealmConfiguration> {
    private final AttributeSet attributes = LdapRealmConfiguration.attributeDefinitionSet();
    private final LdapIdentityMappingConfigurationBuilder identityMapping = new LdapIdentityMappingConfigurationBuilder(this);

    LdapRealmConfigurationBuilder() {
    }

    public LdapIdentityMappingConfigurationBuilder identityMapping() {
        return this.identityMapping;
    }

    public LdapRealmConfigurationBuilder name(String name) {
        this.attributes.attribute(LdapRealmConfiguration.NAME).set((Object)name);
        return this;
    }

    public LdapRealmConfigurationBuilder url(String url) {
        this.attributes.attribute(LdapRealmConfiguration.URL).set((Object)url);
        return this;
    }

    public LdapRealmConfigurationBuilder principal(String principal) {
        this.attributes.attribute(LdapRealmConfiguration.PRINCIPAL).set((Object)principal);
        return this;
    }

    public LdapRealmConfigurationBuilder credential(char[] credential) {
        this.attributes.attribute(LdapRealmConfiguration.CREDENTIAL).set((Object)new InstanceSupplier((Object)credential));
        return this;
    }

    public LdapRealmConfigurationBuilder credential(Supplier<char[]> credential) {
        this.attributes.attribute(LdapRealmConfiguration.CREDENTIAL).set(credential);
        return this;
    }

    public LdapRealmConfigurationBuilder directEvidenceVerification(boolean value) {
        this.attributes.attribute(LdapRealmConfiguration.DIRECT_EVIDENCE_VERIFICATION).set((Object)value);
        return this;
    }

    public LdapRealmConfigurationBuilder pageSize(int value) {
        this.attributes.attribute(LdapRealmConfiguration.PAGE_SIZE).set((Object)value);
        return this;
    }

    public LdapRealmConfigurationBuilder nameRewriter(NameRewriter rewriter) {
        this.attributes.attribute(LdapRealmConfiguration.NAME_REWRITER).set((Object)rewriter);
        return this;
    }

    public LdapRealmConfigurationBuilder connectionTimeout(int connectionTimeout) {
        this.attributes.attribute(LdapRealmConfiguration.CONNECTION_TIMEOUT).set((Object)connectionTimeout);
        return this;
    }

    public LdapRealmConfigurationBuilder readTimeout(int readTimeout) {
        this.attributes.attribute(LdapRealmConfiguration.READ_TIMEOUT).set((Object)readTimeout);
        return this;
    }

    public LdapRealmConfigurationBuilder connectionPooling(boolean connectionPooling) {
        this.attributes.attribute(LdapRealmConfiguration.CONNECTION_POOLING).set((Object)connectionPooling);
        return this;
    }

    public LdapRealmConfigurationBuilder referralMode(DirContextFactory.ReferralMode referralMode) {
        this.attributes.attribute(LdapRealmConfiguration.REFERRAL_MODE).set((Object)referralMode);
        return this;
    }

    public void validate() {
        this.identityMapping.validate();
    }

    public LdapRealmConfiguration create() {
        return new LdapRealmConfiguration(this.attributes.protect(), this.identityMapping.create());
    }

    public LdapRealmConfigurationBuilder read(LdapRealmConfiguration template) {
        this.attributes.read(template.attributes());
        this.identityMapping.read(template.identityMapping());
        return this;
    }
}

