/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.function.Supplier;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.InstanceSupplier;
import org.infinispan.server.configuration.security.OAuth2Configuration;

public class OAuth2ConfigurationBuilder
implements Builder<OAuth2Configuration> {
    private final AttributeSet attributes = OAuth2Configuration.attributeDefinitionSet();

    OAuth2ConfigurationBuilder() {
    }

    boolean isModified() {
        return this.attributes.isModified();
    }

    public OAuth2ConfigurationBuilder clientId(String clientId) {
        this.attributes.attribute(OAuth2Configuration.CLIENT_ID).set((Object)clientId);
        return this;
    }

    public OAuth2ConfigurationBuilder clientSecret(char[] clientSecret) {
        this.attributes.attribute(OAuth2Configuration.CLIENT_SECRET).set((Object)new InstanceSupplier((Object)clientSecret));
        return this;
    }

    public OAuth2ConfigurationBuilder clientSecret(Supplier<char[]> clientSecret) {
        this.attributes.attribute(OAuth2Configuration.CLIENT_SECRET).set(clientSecret);
        return this;
    }

    public OAuth2ConfigurationBuilder introspectionUrl(String introspectionUrl) {
        this.attributes.attribute(OAuth2Configuration.INTROSPECTION_URL).set((Object)introspectionUrl);
        return this;
    }

    public OAuth2ConfigurationBuilder clientSSLContext(String value) {
        this.attributes.attribute(OAuth2Configuration.CLIENT_SSL_CONTEXT).set((Object)value);
        return this;
    }

    public OAuth2ConfigurationBuilder hostVerificationPolicy(String value) {
        this.attributes.attribute(OAuth2Configuration.HOST_VERIFICATION_POLICY).set((Object)value);
        return this;
    }

    public OAuth2Configuration create() {
        return new OAuth2Configuration(this.attributes.protect());
    }

    public OAuth2ConfigurationBuilder read(OAuth2Configuration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

