/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.Properties;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.server.configuration.security.KeyStoreConfiguration;
import org.infinispan.server.configuration.security.SSLEngineConfiguration;
import org.infinispan.server.configuration.security.TrustStoreConfiguration;
import org.wildfly.security.ssl.SSLContextBuilder;

public class SSLConfiguration {
    private final KeyStoreConfiguration keyStore;
    private final TrustStoreConfiguration trustStore;
    private final SSLEngineConfiguration engine;

    SSLConfiguration(KeyStoreConfiguration keyStore, TrustStoreConfiguration trustStore, SSLEngineConfiguration engine) {
        this.keyStore = keyStore;
        this.trustStore = trustStore;
        this.engine = engine;
    }

    public KeyStoreConfiguration keyStore() {
        return this.keyStore;
    }

    public TrustStoreConfiguration trustStore() {
        return this.trustStore;
    }

    public SSLEngineConfiguration engine() {
        return this.engine;
    }

    SSLContextBuilder build(Properties properties) {
        SSLContextBuilder builder = new SSLContextBuilder().setWrap(false).setProviderName(SslContextFactory.getSslProvider());
        this.keyStore.build(builder, properties);
        this.trustStore.build(builder, properties);
        this.engine.build(builder);
        return builder;
    }
}

