/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.server.configuration.security.KerberosSecurityFactoryConfiguration;
import org.infinispan.server.configuration.security.KerberosSecurityFactoryConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.SSLConfiguration;
import org.infinispan.server.configuration.security.SSLConfigurationBuilder;
import org.infinispan.server.configuration.security.ServerIdentitiesConfiguration;

public class ServerIdentitiesConfigurationBuilder
implements Builder<ServerIdentitiesConfiguration> {
    SSLConfigurationBuilder sslConfigurationBuilder;
    private final List<KerberosSecurityFactoryConfigurationBuilder> kerberosConfigurations = new ArrayList<KerberosSecurityFactoryConfigurationBuilder>();
    private final RealmConfigurationBuilder realmBuilder;

    ServerIdentitiesConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.realmBuilder = realmBuilder;
    }

    public SSLConfigurationBuilder sslConfiguration() {
        if (this.sslConfigurationBuilder == null) {
            this.sslConfigurationBuilder = new SSLConfigurationBuilder(this.realmBuilder);
        }
        return this.sslConfigurationBuilder;
    }

    public KerberosSecurityFactoryConfigurationBuilder addKerberosConfiguration() {
        KerberosSecurityFactoryConfigurationBuilder kerberos = new KerberosSecurityFactoryConfigurationBuilder(this.realmBuilder);
        this.kerberosConfigurations.add(kerberos);
        return kerberos;
    }

    public ServerIdentitiesConfiguration create() {
        SSLConfiguration sslConfiguration = this.sslConfigurationBuilder == null ? null : this.sslConfigurationBuilder.create();
        List<KerberosSecurityFactoryConfiguration> kerberosConfigurations = this.kerberosConfigurations.stream().map(KerberosSecurityFactoryConfigurationBuilder::create).collect(Collectors.toList());
        return new ServerIdentitiesConfiguration(sslConfiguration, kerberosConfigurations);
    }

    public ServerIdentitiesConfigurationBuilder read(ServerIdentitiesConfiguration template) {
        if (template.sslConfiguration() != null) {
            this.sslConfiguration().read(template.sslConfiguration());
        }
        this.kerberosConfigurations.clear();
        template.kerberosConfigurations().forEach(s -> this.addKerberosConfiguration().read((KerberosSecurityFactoryConfiguration)((Object)s)));
        return this;
    }
}

