/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.SocketBindingConfiguration;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.network.SocketBinding;

public class SocketBindingConfigurationBuilder
implements Builder<SocketBindingConfiguration> {
    private final AttributeSet attributes;
    private final ServerConfigurationBuilder server;
    private SocketBinding socketBinding;

    SocketBindingConfigurationBuilder(ServerConfigurationBuilder server) {
        this.server = server;
        this.attributes = SocketBindingConfiguration.attributeDefinitionSet();
    }

    public SocketBindingConfigurationBuilder binding(String name, int port, String interfaceName) {
        this.attributes.attribute(SocketBindingConfiguration.NAME).set((Object)name);
        this.attributes.attribute(SocketBindingConfiguration.PORT).set((Object)port);
        if (!this.server.interfaces().exists(interfaceName)) {
            throw Server.log.unknownInterface(interfaceName);
        }
        this.attributes.attribute(SocketBindingConfiguration.INTERFACE).set((Object)interfaceName);
        NetworkAddress networkAddress = this.server.interfaces().getNetworkAddress(interfaceName);
        int offset = this.server.socketBindings().offset();
        this.socketBinding = new SocketBinding(name, networkAddress, port + offset);
        return this;
    }

    SocketBinding getSocketBinding() {
        return this.socketBinding;
    }

    public void validate() {
    }

    public SocketBindingConfiguration create() {
        return new SocketBindingConfiguration(this.attributes.protect(), this.socketBinding);
    }

    public SocketBindingConfigurationBuilder read(SocketBindingConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

