/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.HashMap;
import java.util.Properties;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.security.CredentialStoreConfiguration;
import org.infinispan.server.configuration.security.CredentialStoresConfigurationBuilder;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.CredentialStoreSpi;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;

public class CredentialStoreConfigurationBuilder
implements Builder<CredentialStoreConfiguration> {
    private final AttributeSet attributes = CredentialStoreConfiguration.attributeDefinitionSet();
    private CredentialStoreSpi credentialStore;

    CredentialStoreConfigurationBuilder(CredentialStoresConfigurationBuilder credentialStoresConfigurationBuilder, String name) {
        this.attributes.attribute(CredentialStoreConfiguration.NAME).set((Object)name);
    }

    public CredentialStoreConfigurationBuilder path(String value) {
        this.attributes.attribute(CredentialStoreConfiguration.PATH).set((Object)value);
        return this;
    }

    public CredentialStoreConfigurationBuilder relativeTo(String relativeTo) {
        this.attributes.attribute(CredentialStoreConfiguration.RELATIVE_TO).set((Object)relativeTo);
        return this;
    }

    public CredentialStoreConfigurationBuilder type(String type) {
        this.attributes.attribute(CredentialStoreConfiguration.TYPE).set((Object)type);
        return this;
    }

    public CredentialStoreConfigurationBuilder credential(String credential) {
        this.attributes.attribute(CredentialStoreConfiguration.CREDENTIAL).set((Object)credential);
        return this;
    }

    public void validate() {
    }

    public CredentialStoreConfiguration create() {
        return new CredentialStoreConfiguration(this.attributes.protect());
    }

    public Builder<?> read(CredentialStoreConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    CredentialStoreSpi build(Properties properties) {
        block4: {
            if (this.credentialStore == null) {
                if (this.attributes.attribute(CredentialStoreConfiguration.PATH).isNull()) {
                    throw new IllegalStateException("file has to be specified");
                }
                String path = (String)this.attributes.attribute(CredentialStoreConfiguration.PATH).get();
                String relativeTo = properties.getProperty((String)this.attributes.attribute(CredentialStoreConfiguration.RELATIVE_TO).get());
                String location = ParseUtils.resolvePath((String)path, (String)relativeTo);
                this.credentialStore = new KeyStoreCredentialStore();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("location", location);
                map.put("create", "false");
                map.put("keyStoreType", (String)this.attributes.attribute(CredentialStoreConfiguration.TYPE).get());
                char[] credential = ((String)this.attributes.attribute(CredentialStoreConfiguration.CREDENTIAL).get()).toCharArray();
                try {
                    this.credentialStore.initialize(map, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])credential)))), null);
                }
                catch (CredentialStoreException e) {
                    if (e.getMessage().startsWith("ELY09518")) break block4;
                    throw new CacheConfigurationException((Exception)((Object)e));
                }
            }
        }
        return this.credentialStore;
    }

    public <C extends Credential> C getCredential(String alias, Class<C> type, Properties properties) {
        this.build(properties);
        try {
            if (alias == null) {
                if (this.credentialStore.getAliases().size() == 1) {
                    alias = (String)this.credentialStore.getAliases().iterator().next();
                } else {
                    throw Server.log.unspecifiedCredentialAlias();
                }
            }
            return (C)this.credentialStore.retrieve(alias, type, null, null, null);
        }
        catch (CredentialStoreException e) {
            throw new CacheConfigurationException((Exception)((Object)e));
        }
    }
}

