/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.security.KeyStoreConfiguration;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.security.KeyStoreUtils;
import org.wildfly.security.keystore.AliasFilter;
import org.wildfly.security.keystore.FilteringKeyStore;
import org.wildfly.security.keystore.KeyStoreUtil;
import org.wildfly.security.provider.util.ProviderUtil;

public class KeyStoreConfigurationBuilder
implements Builder<KeyStoreConfiguration> {
    private final AttributeSet attributes;
    private final RealmConfigurationBuilder realmBuilder;
    private KeyManagerFactory keyManagerFactory;

    KeyStoreConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.realmBuilder = realmBuilder;
        this.attributes = KeyStoreConfiguration.attributeDefinitionSet();
    }

    public KeyStoreConfigurationBuilder alias(String alias) {
        this.attributes.attribute(KeyStoreConfiguration.ALIAS).set((Object)alias);
        return this;
    }

    public KeyStoreConfigurationBuilder keyStorePassword(char[] keyStorePassword) {
        this.attributes.attribute(KeyStoreConfiguration.KEYSTORE_PASSWORD).set((Object)keyStorePassword);
        return this;
    }

    public KeyStoreConfigurationBuilder generateSelfSignedCertificateHost(String certificateHost) {
        this.attributes.attribute(KeyStoreConfiguration.GENERATE_SELF_SIGNED_CERTIFICATE_HOST).set((Object)certificateHost);
        return this;
    }

    public KeyStoreConfigurationBuilder keyPassword(char[] keyPassword) {
        this.attributes.attribute(KeyStoreConfiguration.KEY_PASSWORD).set((Object)keyPassword);
        return this;
    }

    public KeyStoreConfigurationBuilder path(String path) {
        this.attributes.attribute(KeyStoreConfiguration.PATH).set((Object)path);
        return this;
    }

    public KeyStoreConfigurationBuilder provider(String value) {
        this.attributes.attribute(KeyStoreConfiguration.PROVIDER).set((Object)value);
        return this;
    }

    public KeyStoreConfigurationBuilder relativeTo(String relativeTo) {
        this.attributes.attribute(KeyStoreConfiguration.RELATIVE_TO).set((Object)relativeTo);
        return this;
    }

    public void build(Properties properties) {
        if (this.keyManagerFactory == null) {
            try {
                String keyStoreFileName = ParseUtils.resolvePath((String)((String)this.attributes.attribute(KeyStoreConfiguration.PATH).get()), (String)properties.getProperty((String)this.attributes.attribute(KeyStoreConfiguration.RELATIVE_TO).get()));
                String generateSelfSignedHost = (String)this.attributes.attribute(KeyStoreConfiguration.GENERATE_SELF_SIGNED_CERTIFICATE_HOST).get();
                String keyStoreProvider = (String)this.attributes.attribute(KeyStoreConfiguration.PROVIDER).get();
                char[] keyStorePassword = (char[])this.attributes.attribute(KeyStoreConfiguration.KEYSTORE_PASSWORD).get();
                char[] keyPassword = (char[])this.attributes.attribute(KeyStoreConfiguration.KEY_PASSWORD).get();
                String keyAlias = (String)this.attributes.attribute(KeyStoreConfiguration.ALIAS).get();
                if (!new File(keyStoreFileName).exists() && generateSelfSignedHost != null) {
                    KeyStoreUtils.generateSelfSignedCertificate(keyStoreFileName, keyStoreProvider, keyStorePassword, keyPassword, keyAlias, generateSelfSignedHost);
                }
                KeyStore keyStore = KeyStoreUtil.loadKeyStore((Supplier)ProviderUtil.INSTALLED_PROVIDERS, (String)keyStoreProvider, (FileInputStream)new FileInputStream(keyStoreFileName), (String)keyStoreFileName, (char[])keyStorePassword);
                if (keyAlias != null) {
                    keyStore = FilteringKeyStore.filteringKeyStore((KeyStore)keyStore, (Predicate)AliasFilter.fromString((String)keyAlias));
                }
                this.keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                this.keyManagerFactory.init(keyStore, keyPassword != null ? keyPassword : keyStorePassword);
                for (KeyManager keyManager : this.keyManagerFactory.getKeyManagers()) {
                    if (!(keyManager instanceof X509ExtendedKeyManager)) continue;
                    this.realmBuilder.sslContextBuilder().setKeyManager((X509ExtendedKeyManager)keyManager);
                    return;
                }
                throw Server.log.noDefaultKeyManager();
            }
            catch (Exception e) {
                throw new CacheConfigurationException(e);
            }
        }
    }

    public void validate() {
    }

    public KeyStoreConfiguration create() {
        return new KeyStoreConfiguration(this.attributes.protect());
    }

    public KeyStoreConfigurationBuilder read(KeyStoreConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

