/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.FileSystemRealmConfiguration;
import org.infinispan.server.configuration.security.LdapRealmConfiguration;
import org.infinispan.server.configuration.security.LocalRealmConfiguration;
import org.infinispan.server.configuration.security.PropertiesRealmConfiguration;
import org.infinispan.server.configuration.security.ServerIdentitiesConfiguration;
import org.infinispan.server.configuration.security.TokenRealmConfiguration;
import org.infinispan.server.configuration.security.TrustStoreRealmConfiguration;

public class RealmConfiguration
extends ConfigurationElement<RealmConfiguration> {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((Enum)Attribute.NAME, null, String.class).build();
    static final AttributeDefinition<Integer> CACHE_MAX_SIZE = AttributeDefinition.builder((Enum)Attribute.CACHE_MAX_SIZE, (Object)256).build();
    static final AttributeDefinition<Long> CACHE_LIFESPAN = AttributeDefinition.builder((Enum)Attribute.CACHE_LIFESPAN, (Object)-1L).build();
    private final FileSystemRealmConfiguration fileSystemConfiguration;
    private final LdapRealmConfiguration ldapConfiguration;
    private final LocalRealmConfiguration localConfiguration;
    private final TokenRealmConfiguration tokenConfiguration;
    private final TrustStoreRealmConfiguration trustStoreConfiguration;
    private final ServerIdentitiesConfiguration serverIdentitiesConfiguration;
    private final PropertiesRealmConfiguration propertiesRealmConfiguration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RealmConfiguration.class, new AttributeDefinition[]{NAME, CACHE_MAX_SIZE, CACHE_LIFESPAN});
    }

    RealmConfiguration(AttributeSet attributes, FileSystemRealmConfiguration fileSystemConfiguration, LdapRealmConfiguration ldapConfiguration, LocalRealmConfiguration localConfiguration, TokenRealmConfiguration tokenConfiguration, TrustStoreRealmConfiguration trustStoreConfiguration, ServerIdentitiesConfiguration serverIdentitiesConfiguration, PropertiesRealmConfiguration propertiesRealmConfiguration) {
        super((Enum)Element.SECURITY_REALM, attributes, new ConfigurationElement[0]);
        this.fileSystemConfiguration = fileSystemConfiguration;
        this.ldapConfiguration = ldapConfiguration;
        this.localConfiguration = localConfiguration;
        this.tokenConfiguration = tokenConfiguration;
        this.trustStoreConfiguration = trustStoreConfiguration;
        this.serverIdentitiesConfiguration = serverIdentitiesConfiguration;
        this.propertiesRealmConfiguration = propertiesRealmConfiguration;
    }

    public FileSystemRealmConfiguration fileSystemConfiguration() {
        return this.fileSystemConfiguration;
    }

    public LdapRealmConfiguration ldapConfiguration() {
        return this.ldapConfiguration;
    }

    public LocalRealmConfiguration localConfiguration() {
        return this.localConfiguration;
    }

    public TokenRealmConfiguration tokenConfiguration() {
        return this.tokenConfiguration;
    }

    public TrustStoreRealmConfiguration trustStoreConfiguration() {
        return this.trustStoreConfiguration;
    }

    public ServerIdentitiesConfiguration serverIdentitiesConfiguration() {
        return this.serverIdentitiesConfiguration;
    }

    public PropertiesRealmConfiguration propertiesRealm() {
        return this.propertiesRealmConfiguration;
    }

    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public String toString() {
        return "RealmConfiguration{attributes=" + this.attributes + ", fileSystemConfiguration=" + (Object)((Object)this.fileSystemConfiguration) + ", ldapConfiguration=" + (Object)((Object)this.ldapConfiguration) + ", localConfiguration=" + (Object)((Object)this.localConfiguration) + ", tokenConfiguration=" + (Object)((Object)this.tokenConfiguration) + ", trustStoreConfiguration=" + (Object)((Object)this.trustStoreConfiguration) + ", serverIdentitiesConfiguration=" + this.serverIdentitiesConfiguration + ", propertiesRealmConfiguration=" + (Object)((Object)this.propertiesRealmConfiguration) + '}';
    }
}

