/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.JwtConfiguration;
import org.infinispan.server.configuration.security.OAuth2Configuration;

public class TokenRealmConfiguration
extends ConfigurationElement<TokenRealmConfiguration> {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((Enum)Attribute.NAME, null, String.class).build();
    static final AttributeDefinition<String> AUTH_SERVER_URL = AttributeDefinition.builder((Enum)Attribute.AUTH_SERVER_URL, null, String.class).build();
    static final AttributeDefinition<String> CLIENT_ID = AttributeDefinition.builder((Enum)Attribute.CLIENT_ID, null, String.class).build();
    static final AttributeDefinition<String> PRINCIPAL_CLAIM = AttributeDefinition.builder((Enum)Attribute.PRINCIPAL_CLAIM, null, String.class).build();
    private final JwtConfiguration jwtConfiguration;
    private final OAuth2Configuration oAuth2Configuration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(TokenRealmConfiguration.class, new AttributeDefinition[]{NAME, AUTH_SERVER_URL, CLIENT_ID, PRINCIPAL_CLAIM});
    }

    TokenRealmConfiguration(JwtConfiguration jwtConfiguration, OAuth2Configuration oAuth2Configuration, AttributeSet attributes) {
        super((Enum)Element.TOKEN_REALM, attributes, new ConfigurationElement[0]);
        this.jwtConfiguration = jwtConfiguration;
        this.oAuth2Configuration = oAuth2Configuration;
    }

    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public String authServerUrl() {
        return (String)this.attributes.attribute(AUTH_SERVER_URL).get();
    }

    public String clientId() {
        return (String)this.attributes.attribute(CLIENT_ID).get();
    }

    public JwtConfiguration jwtConfiguration() {
        return this.jwtConfiguration;
    }

    public OAuth2Configuration oauth2Configuration() {
        return this.oAuth2Configuration;
    }
}

