/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.JwtConfiguration;

public class JwtConfigurationBuilder
implements Builder<JwtConfiguration> {
    private final AttributeSet attributes = JwtConfiguration.attributeDefinitionSet();

    JwtConfigurationBuilder() {
    }

    boolean isModified() {
        return this.attributes.isModified();
    }

    public JwtConfigurationBuilder audience(String[] audience) {
        this.attributes.attribute(JwtConfiguration.AUDIENCE).set((Object)audience);
        return this;
    }

    public JwtConfigurationBuilder clientSSLContext(String value) {
        this.attributes.attribute(JwtConfiguration.CLIENT_SSL_CONTEXT).set((Object)value);
        return this;
    }

    public JwtConfigurationBuilder hostNameVerificationPolicy(String value) {
        this.attributes.attribute(JwtConfiguration.HOST_NAME_VERIFICATION_POLICY).set((Object)value);
        return this;
    }

    public JwtConfigurationBuilder issuers(String[] issuers) {
        this.attributes.attribute(JwtConfiguration.ISSUER).set((Object)issuers);
        return this;
    }

    public JwtConfigurationBuilder jkuTimeout(long timeout) {
        this.attributes.attribute(JwtConfiguration.JKU_TIMEOUT).set((Object)timeout);
        return this;
    }

    public JwtConfigurationBuilder publicKey(String publicKey) {
        this.attributes.attribute(JwtConfiguration.PUBLIC_KEY).set((Object)publicKey);
        return this;
    }

    public JwtConfigurationBuilder connectionTimeout(int timeout) {
        this.attributes.attribute(JwtConfiguration.CONNECTION_TIMEOUT).set((Object)timeout);
        return this;
    }

    public JwtConfigurationBuilder readTimeout(int timeout) {
        this.attributes.attribute(JwtConfiguration.READ_TIMEOUT).set((Object)timeout);
        return this;
    }

    public JwtConfiguration create() {
        return new JwtConfiguration(this.attributes.protect());
    }

    public JwtConfigurationBuilder read(JwtConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

