/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Supplier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.ServerConfigurationSerializer;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.security.HostnameVerificationPolicy;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.realm.token.validator.OAuth2IntrospectValidator;

public class OAuth2Configuration
extends ConfigurationElement<OAuth2Configuration> {
    static final AttributeDefinition<String> CLIENT_ID = AttributeDefinition.builder((Enum)Attribute.CLIENT_ID, null, String.class).immutable().build();
    static final AttributeDefinition<Supplier<char[]>> CLIENT_SECRET = AttributeDefinition.builder((Enum)Attribute.CLIENT_SECRET, null, Supplier.class).serializer(ServerConfigurationSerializer.CREDENTIAL).immutable().build();
    static final AttributeDefinition<String> CLIENT_SSL_CONTEXT = AttributeDefinition.builder((Enum)Attribute.CLIENT_SSL_CONTEXT, null, String.class).immutable().build();
    static final AttributeDefinition<String> HOST_VERIFICATION_POLICY = AttributeDefinition.builder((Enum)Attribute.HOST_NAME_VERIFICATION_POLICY, null, String.class).immutable().build();
    static final AttributeDefinition<String> INTROSPECTION_URL = AttributeDefinition.builder((Enum)Attribute.INTROSPECTION_URL, null, String.class).immutable().build();
    static final AttributeDefinition<Integer> CONNECTION_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.CONNECTION_TIMEOUT, (Object)2000, Integer.class).immutable().build();
    static final AttributeDefinition<Integer> READ_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.READ_TIMEOUT, (Object)2000, Integer.class).immutable().build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(OAuth2Configuration.class, new AttributeDefinition[]{CLIENT_ID, CLIENT_SSL_CONTEXT, INTROSPECTION_URL, HOST_VERIFICATION_POLICY, CONNECTION_TIMEOUT, READ_TIMEOUT, CLIENT_SECRET});
    }

    OAuth2Configuration(AttributeSet attributes) {
        super((Enum)Element.OAUTH2_INTROSPECTION, attributes, new ConfigurationElement[0]);
    }

    TokenValidator getValidator(SecurityConfiguration security, RealmConfiguration realm) {
        URL url;
        OAuth2IntrospectValidator.Builder validatorBuilder = OAuth2IntrospectValidator.builder();
        validatorBuilder.clientId((String)this.attributes.attribute(CLIENT_ID).get());
        validatorBuilder.clientSecret(new String((char[])((Supplier)this.attributes.attribute(CLIENT_SECRET).get()).get()));
        try {
            url = new URL((String)this.attributes.attribute(INTROSPECTION_URL).get());
            validatorBuilder.tokenIntrospectionUrl(url);
        }
        catch (MalformedURLException e) {
            throw Server.log.invalidUrl((String)this.attributes.attribute(INTROSPECTION_URL).get());
        }
        if ("https".equalsIgnoreCase(url.getProtocol())) {
            RealmConfiguration sslRealm = this.attributes.attribute(CLIENT_SSL_CONTEXT).isNull() ? realm : security.realms().getRealm((String)this.attributes.attribute(CLIENT_SSL_CONTEXT).get());
            validatorBuilder.useSslContext(sslRealm.clientSSLContext());
            if (!this.attributes.attribute(HOST_VERIFICATION_POLICY).isNull()) {
                validatorBuilder.useSslHostnameVerifier(HostnameVerificationPolicy.valueOf((String)this.attributes.attribute(HOST_VERIFICATION_POLICY).get()).getVerifier());
            }
        }
        return validatorBuilder.build();
    }
}

