/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.FileSystemRealmConfiguration;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.RealmProvider;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.wildfly.security.auth.realm.DistributedSecurityRealm;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;

public class DistributedRealmConfiguration
extends ConfigurationElement<FileSystemRealmConfiguration>
implements RealmProvider {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((String)"name", (Object)"distributed", String.class).build();
    static final AttributeDefinition<List<String>> REALMS = AttributeDefinition.builder((String)"realms", null, List.class).initializer(ArrayList::new).immutable().build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(DistributedRealmConfiguration.class, new AttributeDefinition[]{NAME, REALMS});
    }

    DistributedRealmConfiguration(AttributeSet attributes) {
        super((Enum)Element.DISTRIBUTED_REALM, attributes, new ConfigurationElement[0]);
    }

    @Override
    public SecurityRealm build(SecurityConfiguration securityConfiguration, RealmConfiguration realm, SecurityDomain.Builder domainBuilder, Properties properties) {
        SecurityRealm[] securityRealms;
        domainBuilder.setDefaultRealmName(this.name());
        List<String> names = this.realms();
        if (names.isEmpty()) {
            securityRealms = realm.realms.values().toArray(new SecurityRealm[0]);
        } else {
            securityRealms = new SecurityRealm[names.size()];
            for (int i = 0; i < names.size(); ++i) {
                SecurityRealm securityRealm = realm.realms.get(names.get(i));
                if (securityRealm == null) {
                    throw Server.log.unknownRealm(names.get(i));
                }
                securityRealms[i] = securityRealm;
            }
        }
        return new DistributedSecurityRealm(securityRealms);
    }

    @Override
    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public List<String> realms() {
        return (List)this.attributes.attribute(REALMS).get();
    }
}

