/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.function.Supplier;
import javax.security.auth.x500.X500Principal;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.keystore.KeyStoreUtil;
import org.wildfly.security.pem.Pem;
import org.wildfly.security.pem.PemEntry;
import org.wildfly.security.x500.cert.X509CertificateBuilder;

public class KeyStoreUtils {
    public static void generateSelfSignedCertificate(String keyStoreFileName, String keyStoreType, char[] keyStorePassword, char[] keyStoreCertificatePassword, String keyAlias, String host) throws IOException, GeneralSecurityException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048, new SecureRandom());
        KeyPair pair = keyGen.generateKeyPair();
        PrivateKey privkey = pair.getPrivate();
        X509CertificateBuilder builder = new X509CertificateBuilder();
        Date from = new Date();
        Date to = new Date(from.getTime() + 315360000000L);
        BigInteger sn = new BigInteger(64, new SecureRandom());
        builder.setNotValidAfter(ZonedDateTime.ofInstant(Instant.ofEpochMilli(to.getTime()), TimeZone.getDefault().toZoneId()));
        builder.setNotValidBefore(ZonedDateTime.ofInstant(Instant.ofEpochMilli(from.getTime()), TimeZone.getDefault().toZoneId()));
        builder.setSerialNumber(sn);
        X500Principal owner = new X500Principal("CN=" + host);
        builder.setSubjectDn(owner);
        builder.setIssuerDn(owner);
        builder.setPublicKey(pair.getPublic());
        builder.setVersion(3);
        builder.setSignatureAlgorithmName("SHA256withRSA");
        builder.setSigningKey(privkey);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, keyStorePassword);
        Certificate[] chain = new X509Certificate[]{builder.build()};
        keyStore.setKeyEntry(keyAlias, pair.getPrivate(), keyStoreCertificatePassword != null ? keyStoreCertificatePassword : keyStorePassword, chain);
        try (FileOutputStream stream = new FileOutputStream(keyStoreFileName);){
            keyStore.store(stream, keyStorePassword);
        }
    }

    public static KeyStore loadKeyStore(Supplier<Provider[]> providers, String providerName, FileInputStream is, String filename, char[] password) throws IOException, GeneralSecurityException {
        try {
            return KeyStoreUtil.loadKeyStore(providers, (String)providerName, (FileInputStream)is, (String)filename, (char[])password);
        }
        catch (KeyStoreException e) {
            return KeyStoreUtils.loadPemAsKeyStore(filename, password);
        }
    }

    public static KeyStore loadPemAsKeyStore(String filename, char[] password) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        PrivateKey pk = null;
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        byte[] bytes = Files.readAllBytes(Paths.get(filename, new String[0]));
        Iterator it = Pem.parsePemContent((CodePointIterator)CodePointIterator.ofUtf8Bytes((byte[])bytes));
        while (it.hasNext()) {
            Object entry = ((PemEntry)it.next()).getEntry();
            if (entry instanceof PrivateKey) {
                pk = (PrivateKey)entry;
                continue;
            }
            if (!(entry instanceof Certificate)) continue;
            Certificate certificate = (Certificate)entry;
            certificates.add(certificate);
        }
        if (pk != null) {
            keyStore.setKeyEntry("key", pk, password, certificates.toArray(new Certificate[0]));
        } else {
            int i = 1;
            for (Certificate certificate : certificates) {
                keyStore.setCertificateEntry(Integer.toString(i++), certificate);
            }
        }
        return keyStore;
    }
}

