/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.memcached;

import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfigurationParser;
import org.infinispan.server.configuration.memcached.Attribute;
import org.infinispan.server.configuration.memcached.Element;
import org.infinispan.server.memcached.configuration.MemcachedServerConfigurationBuilder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(root="memcached-connector"), @Namespace(uri="urn:infinispan:server:*", root="memcached-connector")})
public class MemcachedServerConfigurationParser
implements ConfigurationParser {
    private static Log coreLog = LogFactory.getLog(ServerConfigurationParser.class);

    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        if (!holder.inScope(ServerConfigurationParser.ENDPOINTS_SCOPE)) {
            throw coreLog.invalidScope(ServerConfigurationParser.ENDPOINTS_SCOPE, holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case MEMCACHED_CONNECTOR: {
                ServerConfigurationBuilder serverBuilder = (ServerConfigurationBuilder)builder.module(ServerConfigurationBuilder.class);
                if (serverBuilder != null) {
                    this.parseMemcached(reader, serverBuilder, serverBuilder.endpoints().current().addConnector(MemcachedServerConfigurationBuilder.class));
                    break;
                }
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private void parseMemcached(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, MemcachedServerConfigurationBuilder builder) {
        String[] required = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.SOCKET_BINDING});
        builder.startTransport(true);
        builder.socketBinding(required[0]);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case CACHE: {
                    builder.cache(value);
                    continue block9;
                }
                case CACHE_CONTAINER: {
                    continue block9;
                }
                case CLIENT_ENCODING: {
                    builder.clientEncoding(MediaType.fromString((String)value));
                    continue block9;
                }
                case IDLE_TIMEOUT: {
                    builder.idleTimeout(Integer.parseInt(value));
                    continue block9;
                }
                case IO_THREADS: {
                    builder.ioThreads(Integer.parseInt(value));
                    continue block9;
                }
                case NAME: {
                    builder.name(value);
                    continue block9;
                }
                case SOCKET_BINDING: {
                    continue block9;
                }
                default: {
                    ServerConfigurationParser.parseCommonConnectorAttributes(reader, i, serverBuilder, builder);
                }
            }
        }
        while (reader.inTag()) {
            ServerConfigurationParser.parseCommonConnectorElements(reader, builder);
        }
    }
}

