package org.infinispan.server.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.infinispan.commons.util.OS;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import org.wildfly.security.auth.server.RealmUnavailableException;
import java.lang.SecurityException;
import java.lang.String;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.KeyStoreException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import javax.naming.NamingException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.util.NoSuchElementException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.FATAL;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-02-11T11:20:47-0500")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void serverStarting(final String name) {
        super.log.logf(FQCN, INFO, null, serverStarting$str(), name);
    }
    private static final String serverStarting = "ISPN080000: %s Server starting";
    protected String serverStarting$str() {
        return serverStarting;
    }
    @Override
    public final void serverStarted(final String name, final String version, final long ms) {
        super.log.logf(FQCN, INFO, null, serverStarted$str(), name, version, ms);
    }
    private static final String serverStarted = "ISPN080001: %s Server %s started in %dms";
    protected String serverStarted$str() {
        return serverStarted;
    }
    @Override
    public final void serverStopping(final String name) {
        super.log.logf(FQCN, INFO, null, serverStopping$str(), name);
    }
    private static final String serverStopping = "ISPN080002: %s Server stopping";
    protected String serverStopping$str() {
        return serverStopping;
    }
    @Override
    public final void serverStopped(final String name) {
        super.log.logf(FQCN, INFO, null, serverStopped$str(), name);
    }
    private static final String serverStopped = "ISPN080003: %s Server stopped";
    protected String serverStopped$str() {
        return serverStopped;
    }
    @Override
    public final void protocolStarted(final String name, final String socketBinding, final String host, final int port) {
        super.log.logf(FQCN, INFO, null, protocolStarted4$str(), name, socketBinding, host, port);
    }
    private static final String protocolStarted4 = "ISPN080004: Connector %s (%s) listening on %s:%d";
    protected String protocolStarted4$str() {
        return protocolStarted4;
    }
    private static final String cannotInstantiateProtocolServerConfigurationBuilder = "ISPN080008: Cannot instantiate protocol server configuration '%s'";
    protected String cannotInstantiateProtocolServerConfigurationBuilder$str() {
        return cannotInstantiateProtocolServerConfigurationBuilder;
    }
    @Override
    public final CacheConfigurationException cannotInstantiateProtocolServerConfigurationBuilder(final Class<?> klass, final Exception e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotInstantiateProtocolServerConfigurationBuilder$str(), klass), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownInterface = "ISPN080009: Unknown interface '%s'";
    protected String unknownInterface$str() {
        return unknownInterface;
    }
    @Override
    public final CacheConfigurationException unknownInterface(final String interfaceName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownInterface$str(), interfaceName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownSocketBinding = "ISPN080010: Unknown socket binding '%s'";
    protected String unknownSocketBinding$str() {
        return unknownSocketBinding;
    }
    @Override
    public final CacheConfigurationException unknownSocketBinding(final String value) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownSocketBinding$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownSecurityDomain = "ISPN080014: Unknown security domain '%s'";
    protected String unknownSecurityDomain$str() {
        return unknownSecurityDomain;
    }
    @Override
    public final CacheConfigurationException unknownSecurityDomain(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownSecurityDomain$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadRealmPropertyFiles = "ISPN080015: Unable to load realm property files";
    protected String unableToLoadRealmPropertyFiles$str() {
        return unableToLoadRealmPropertyFiles;
    }
    @Override
    public final CacheConfigurationException unableToLoadRealmPropertyFiles(final IOException e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unableToLoadRealmPropertyFiles$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDefaultKeyManager = "ISPN080016: No default key manager available";
    protected String noDefaultKeyManager$str() {
        return noDefaultKeyManager;
    }
    @Override
    public final NoSuchAlgorithmException noDefaultKeyManager() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noDefaultKeyManager$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void serverConfiguration(final String name) {
        super.log.logf(FQCN, INFO, null, serverConfiguration$str(), name);
    }
    private static final String serverConfiguration = "ISPN080017: Server configuration: %s";
    protected String serverConfiguration$str() {
        return serverConfiguration;
    }
    @Override
    public final void protocolStarted(final String name) {
        super.log.logf(FQCN, INFO, null, protocolStarted1$str(), name);
    }
    private static final String protocolStarted1 = "ISPN080018: Started connector %s (internal)";
    protected String protocolStarted1$str() {
        return protocolStarted1;
    }
    private static final String trustStoreWithoutServerIdentity = "ISPN080020: Cannot use a trust store without a server identity";
    protected String trustStoreWithoutServerIdentity$str() {
        return trustStoreWithoutServerIdentity;
    }
    @Override
    public final CacheConfigurationException trustStoreWithoutServerIdentity() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), trustStoreWithoutServerIdentity$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authenticationWithoutSecurityRealm = "ISPN080021: Authentication cannot be configured without a security realm";
    protected String authenticationWithoutSecurityRealm$str() {
        return authenticationWithoutSecurityRealm;
    }
    @Override
    public final CacheConfigurationException authenticationWithoutSecurityRealm() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), authenticationWithoutSecurityRealm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotConfigureProtocolEncryptionUnderSinglePort = "ISPN080022: Cannot configure protocol encryption under a single port endpoint. Use a dedicated socket binding.";
    protected String cannotConfigureProtocolEncryptionUnderSinglePort$str() {
        return cannotConfigureProtocolEncryptionUnderSinglePort;
    }
    @Override
    public final CacheConfigurationException cannotConfigureProtocolEncryptionUnderSinglePort() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotConfigureProtocolEncryptionUnderSinglePort$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String protocolCannotUseSameSocketBindingAsEndpoint = "ISPN080023: Cannot configure a protocol with the same socket binding used by the endpoint. Use a dedicated socket binding.";
    protected String protocolCannotUseSameSocketBindingAsEndpoint$str() {
        return protocolCannotUseSameSocketBindingAsEndpoint;
    }
    @Override
    public final CacheConfigurationException protocolCannotUseSameSocketBindingAsEndpoint() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), protocolCannotUseSameSocketBindingAsEndpoint$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidUrl = "ISPN080024: Invalid URL: '%s'";
    protected String invalidUrl$str() {
        return invalidUrl;
    }
    @Override
    public final CacheConfigurationException invalidUrl(final String url) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidUrl$str(), url));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleEndpointsSameTypeFound = "ISPN080025: Cannot have multiple connectors of the same type: found [%s]";
    protected String multipleEndpointsSameTypeFound$str() {
        return multipleEndpointsSameTypeFound;
    }
    @Override
    public final CacheConfigurationException multipleEndpointsSameTypeFound(final String names) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), multipleEndpointsSameTypeFound$str(), names));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unnamedFactoryClass(final String name) {
        super.log.logf(FQCN, WARN, null, unnamedFactoryClass$str(), name);
    }
    private static final String unnamedFactoryClass = "ISPN080026: Extension factory '%s' is lacking a @NamedFactory annotation";
    protected String unnamedFactoryClass$str() {
        return unnamedFactoryClass;
    }
    @Override
    public final void loadedExtension(final String name) {
        super.log.logf(FQCN, INFO, null, loadedExtension$str(), name);
    }
    private static final String loadedExtension = "ISPN080027: Loaded extension '%s'";
    protected String loadedExtension$str() {
        return loadedExtension;
    }
    @Override
    public final void serverFailedToStart(final String name, final Throwable t) {
        super.log.logf(FQCN, FATAL, t, serverFailedToStart$str(), name);
    }
    private static final String serverFailedToStart = "ISPN080028: %s Server failed to start";
    protected String serverFailedToStart$str() {
        return serverFailedToStart;
    }
    @Override
    public final void clusterShutdown() {
        super.log.logf(FQCN, INFO, null, clusterShutdown$str());
    }
    private static final String clusterShutdown = "ISPN080029: Cluster shutdown";
    protected String clusterShutdown$str() {
        return clusterShutdown;
    }
    @Override
    public final void clusteredTaskError(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, clusteredTaskError$str());
    }
    private static final String clusteredTaskError = "ISPN080030: Clustered task error";
    protected String clusteredTaskError$str() {
        return clusteredTaskError;
    }
    private static final String unknownServerIdentity = "ISPN080031: Unknown server identity '%s'";
    protected String unknownServerIdentity$str() {
        return unknownServerIdentity;
    }
    @Override
    public final IllegalArgumentException unknownServerIdentity(final String serverPrincipal) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownServerIdentity$str(), serverPrincipal));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void loggingConfiguration(final String absolutePath) {
        super.log.logf(FQCN, INFO, null, loggingConfiguration$str(), absolutePath);
    }
    private static final String loggingConfiguration = "ISPN080032: Logging configuration: %s";
    protected String loggingConfiguration$str() {
        return loggingConfiguration;
    }
    private static final String invalidNetworkConfiguration = "ISPN080033: Cannot find a network address which matches the supplied configuration";
    protected String invalidNetworkConfiguration$str() {
        return invalidNetworkConfiguration;
    }
    @Override
    public final CacheConfigurationException invalidNetworkConfiguration() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidNetworkConfiguration$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void endpointUrl(final Object name, final String proto, final String host, final int port) {
        super.log.logf(FQCN, INFO, null, endpointUrl$str(), name, proto, host, port);
    }
    private static final String endpointUrl = "ISPN080034: Server '%s' listening on %s://%s:%d";
    protected String endpointUrl$str() {
        return endpointUrl;
    }
    private static final String unknownAppender = "ISPN080035: Unknown appender `%s`";
    protected String unknownAppender$str() {
        return unknownAppender;
    }
    @Override
    public final IllegalArgumentException unknownAppender(final String appender) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownAppender$str(), appender));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidLevel = "ISPN080036: Invalid level `%s`";
    protected String invalidLevel$str() {
        return invalidLevel;
    }
    @Override
    public final IllegalArgumentException invalidLevel(final String level) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidLevel$str(), level));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nameAlreadyBound = "ISPN080037: The name '%s' is already bound";
    protected String nameAlreadyBound$str() {
        return nameAlreadyBound;
    }
    @Override
    public final NamingException nameAlreadyBound(final String name) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), nameAlreadyBound$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void dataSourceCreated(final String name, final String jndiName) {
        super.log.logf(FQCN, INFO, null, dataSourceCreated$str(), name, jndiName);
    }
    private static final String dataSourceCreated = "ISPN080038: Created datasource '%s' bound to JNDI '%s'";
    protected String dataSourceCreated$str() {
        return dataSourceCreated;
    }
    private static final String invalidUnicodeSequence = "ISPN080039: Invalid Unicode sequence '%s'";
    protected String invalidUnicodeSequence$str() {
        return invalidUnicodeSequence;
    }
    @Override
    public final IOException invalidUnicodeSequence(final String sequence, final NoSuchElementException e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidUnicodeSequence$str(), sequence), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noRealmFoundInProperties = "ISPN080040: No realm name found in users property file - non-plain-text users file must contain \"#$REALM_NAME=RealmName$\" line";
    protected String noRealmFoundInProperties$str() {
        return noRealmFoundInProperties;
    }
    @Override
    public final RealmUnavailableException noRealmFoundInProperties() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), noRealmFoundInProperties$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateDataSource = "ISPN080041: Duplicate data source '%s'";
    protected String duplicateDataSource$str() {
        return duplicateDataSource;
    }
    @Override
    public final CacheConfigurationException duplicateDataSource(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateDataSource$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateJndiName = "ISPN080042: Duplicate JNDI name '%s'";
    protected String duplicateJndiName$str() {
        return duplicateJndiName;
    }
    @Override
    public final CacheConfigurationException duplicateJndiName(final String jndiName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateJndiName$str(), jndiName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverReportUnavailable = "ISPN080043: Cannot generate the server report on %s";
    protected String serverReportUnavailable$str() {
        return serverReportUnavailable;
    }
    @Override
    public final IllegalStateException serverReportUnavailable(final OS os) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serverReportUnavailable$str(), os));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void warnHotRodLazyRetrievalDeprecated() {
        super.log.logf(FQCN, WARN, null, warnHotRodLazyRetrievalDeprecated$str());
    }
    private static final String warnHotRodLazyRetrievalDeprecated = "ISPN080044: HotRod lazy-retrieval has been deprecated and will be removed in a future version with no direct replacement";
    protected String warnHotRodLazyRetrievalDeprecated$str() {
        return warnHotRodLazyRetrievalDeprecated;
    }
    private static final String endpointSocketBindingConflict = "ISPN080045: Cannot have multiple endpoints bound to the same socket binding '%s'";
    protected String endpointSocketBindingConflict$str() {
        return endpointSocketBindingConflict;
    }
    @Override
    public final CacheConfigurationException endpointSocketBindingConflict(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), endpointSocketBindingConflict$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownCredentialStore = "ISPN080046: Unknown credential store '%s'";
    protected String unknownCredentialStore$str() {
        return unknownCredentialStore;
    }
    @Override
    public final IllegalArgumentException unknownCredentialStore(final String store) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownCredentialStore$str(), store));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownCredential = "ISPN080047: Unknown credential '%s' in store '%s'";
    protected String unknownCredential$str() {
        return unknownCredential;
    }
    @Override
    public final IllegalArgumentException unknownCredential(final String alias, final String store) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownCredential$str(), alias, store));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingCredentialStoreName = "ISPN080048: A credential store name is missing";
    protected String missingCredentialStoreName$str() {
        return missingCredentialStoreName;
    }
    @Override
    public final IllegalArgumentException missingCredentialStoreName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingCredentialStoreName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unspecifiedCredentialAlias = "ISPN080049: A credential alias must be specified if the store doesn't contain a single alias";
    protected String unspecifiedCredentialAlias$str() {
        return unspecifiedCredentialAlias;
    }
    @Override
    public final CacheConfigurationException unspecifiedCredentialAlias() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unspecifiedCredentialAlias$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotOverrideCredential = "ISPN080050: Credential reference in element '%s' would override value specified in attribute '%s'";
    protected String cannotOverrideCredential$str() {
        return cannotOverrideCredential;
    }
    @Override
    public final CacheConfigurationException cannotOverrideCredential(final String element, final String attribute) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotOverrideCredential$str(), element, attribute));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingCredential = "ISPN080051: Element '%s' is missing a credential attribute '%s' or a credential reference";
    protected String missingCredential$str() {
        return missingCredential;
    }
    @Override
    public final CacheConfigurationException missingCredential(final String element, final String attribute) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingCredential$str(), element, attribute));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedMechanism = "ISPN080052: The request authentication mechanism '%s' is not supported";
    protected String unsupportedMechanism$str() {
        return unsupportedMechanism;
    }
    @Override
    public final SecurityException unsupportedMechanism(final String mechName) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), unsupportedMechanism$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String encryptionWithoutSecurityRealm = "ISPN080053: Encryption cannot be configured without a security realm";
    protected String encryptionWithoutSecurityRealm$str() {
        return encryptionWithoutSecurityRealm;
    }
    @Override
    public final CacheConfigurationException encryptionWithoutSecurityRealm() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), encryptionWithoutSecurityRealm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDefaultTrustManager = "ISPN080054: No default trust manager available";
    protected String noDefaultTrustManager$str() {
        return noDefaultTrustManager;
    }
    @Override
    public final CacheConfigurationException noDefaultTrustManager() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noDefaultTrustManager$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void connectorIpFilterSet(final String connector, final java.util.List<org.infinispan.server.core.transport.IpSubnetFilterRule> rules) {
        super.log.logf(FQCN, INFO, null, connectorIpFilterSet$str(), connector, rules);
    }
    private static final String connectorIpFilterSet = "ISPN080055: Connector '%s': IP filter set: %s";
    protected String connectorIpFilterSet$str() {
        return connectorIpFilterSet;
    }
    @Override
    public final void connectorIpFilterCleared(final String connector) {
        super.log.logf(FQCN, INFO, null, connectorIpFilterCleared$str(), connector);
    }
    private static final String connectorIpFilterCleared = "ISPN080056: Connector '%s': IP filter cleared";
    protected String connectorIpFilterCleared$str() {
        return connectorIpFilterCleared;
    }
    @Override
    public final void connectorStopped(final String connector) {
        super.log.logf(FQCN, INFO, null, connectorStopped$str(), connector);
    }
    private static final String connectorStopped = "ISPN080057: Connector '%s': stopped";
    protected String connectorStopped$str() {
        return connectorStopped;
    }
    @Override
    public final void connectorStarted(final String connector) {
        super.log.logf(FQCN, INFO, null, connectorStarted$str(), connector);
    }
    private static final String connectorStarted = "ISPN080058: Connector '%s': started";
    protected String connectorStarted$str() {
        return connectorStarted;
    }
    @Override
    public final void noScriptEngines() {
        super.log.logf(FQCN, WARN, null, noScriptEngines$str());
    }
    private static final String noScriptEngines = "ISPN080059: No script engines are available";
    protected String noScriptEngines$str() {
        return noScriptEngines;
    }
    @Override
    public final void sslTransport(final String value) {
        super.log.logf(FQCN, INFO, null, sslTransport$str(), value);
    }
    private static final String sslTransport = "ISPN080060: SSL Transport using realm '%s`";
    protected String sslTransport$str() {
        return sslTransport;
    }
    private static final String noSSLContext = "ISPN080061: Realm '%s' does not provide an SSL context";
    protected String noSSLContext$str() {
        return noSSLContext;
    }
    @Override
    public final IllegalStateException noSSLContext(final String realm) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noSSLContext$str(), realm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateRealmType = "ISPN080062: Cannot add multiple realms of type '%s' to security realm '%s'";
    protected String duplicateRealmType$str() {
        return duplicateRealmType;
    }
    @Override
    public final CacheConfigurationException duplicateRealmType(final String type, final String realm) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateRealmType$str(), type, realm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateRealm = "ISPN080063: Duplicate realm '%s'";
    protected String duplicateRealm$str() {
        return duplicateRealm;
    }
    @Override
    public final CacheConfigurationException duplicateRealm(final String realmName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateRealm$str(), realmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownRealm = "ISPN080064: Unknown realm '%s'";
    protected String unknownRealm$str() {
        return unknownRealm;
    }
    @Override
    public final CacheConfigurationException unknownRealm(final String realmName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownRealm$str(), realmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyStore = "ISPN080065: Invalid keystore '%s'";
    protected String invalidKeyStore$str() {
        return invalidKeyStore;
    }
    @Override
    public final KeyStoreException invalidKeyStore(final String filename) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), invalidKeyStore$str(), filename));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
