/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.security.KeyStore;
import java.util.HashMap;
import java.util.Properties;
import java.util.function.Supplier;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.CredentialStoresConfiguration;
import org.infinispan.server.security.ElytronPasswordProviderSupplier;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.CredentialStoreSpi;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;

public class CredentialStoreConfiguration
extends ConfigurationElement<CredentialStoresConfiguration> {
    public static final AttributeDefinition<String> NAME = AttributeDefinition.builder((Enum)Attribute.NAME, null, String.class).build();
    public static final AttributeDefinition<String> PATH = AttributeDefinition.builder((Enum)Attribute.PATH, null, String.class).build();
    public static final AttributeDefinition<String> RELATIVE_TO = AttributeDefinition.builder((Enum)Attribute.RELATIVE_TO, (Object)"infinispan.server.config.path", String.class).autoPersist(false).build();
    public static final AttributeDefinition<String> TYPE = AttributeDefinition.builder((Enum)Attribute.TYPE, (Object)"pkcs12", String.class).build();
    static final AttributeDefinition<Supplier<char[]>> CREDENTIAL = AttributeDefinition.builder((Enum)Attribute.CREDENTIAL, null, Supplier.class).serializer((writer, name, value) -> {
        writer.writeStartElement((Enum)Element.CLEAR_TEXT_CREDENTIAL);
        if (writer.clearTextSecrets()) {
            writer.writeAttribute((Enum)Attribute.CLEAR_TEXT, new String((char[])value.get()));
        } else {
            writer.writeAttribute((Enum)Attribute.CLEAR_TEXT, "***");
        }
        writer.writeEndElement();
    }).build();
    private CredentialStoreSpi credentialStore;

    static AttributeSet attributeDefinitionSet() {
        KeyStore.getDefaultType();
        return new AttributeSet(CredentialStoreConfiguration.class, new AttributeDefinition[]{NAME, PATH, RELATIVE_TO, TYPE, CREDENTIAL});
    }

    CredentialStoreConfiguration(AttributeSet attributes) {
        super((Enum)Element.CREDENTIAL_STORE, attributes, new ConfigurationElement[0]);
    }

    void init(Properties properties) {
        block4: {
            if (this.credentialStore == null) {
                if (this.attributes.attribute(PATH).isNull()) {
                    throw new IllegalStateException("file has to be specified");
                }
                String path = (String)this.attributes.attribute(PATH).get();
                String relativeTo = properties.getProperty((String)this.attributes.attribute(RELATIVE_TO).get());
                String location = ParseUtils.resolvePath((String)path, (String)relativeTo);
                this.credentialStore = new KeyStoreCredentialStore();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("location", location);
                map.put("create", "false");
                map.put("keyStoreType", (String)this.attributes.attribute(TYPE).get());
                char[] credential = (char[])((Supplier)this.attributes.attribute(CREDENTIAL).get()).get();
                try {
                    this.credentialStore.initialize(map, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])credential)))), ElytronPasswordProviderSupplier.PROVIDERS);
                }
                catch (CredentialStoreException e) {
                    if (e.getMessage().startsWith("ELY09518")) break block4;
                    throw new CacheConfigurationException((Exception)((Object)e));
                }
            }
        }
    }

    public <C extends Credential> C getCredential(String alias, Class<C> type) {
        try {
            if (alias == null) {
                if (this.credentialStore.getAliases().size() == 1) {
                    alias = (String)this.credentialStore.getAliases().iterator().next();
                } else {
                    throw Server.log.unspecifiedCredentialAlias();
                }
            }
            return (C)this.credentialStore.retrieve(alias, type, null, null, null);
        }
        catch (CredentialStoreException e) {
            throw new CacheConfigurationException((Exception)((Object)e));
        }
    }
}

