/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.resp.Authenticator;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.security.RolePrincipal;
import org.infinispan.util.concurrent.BlockingManager;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

public class ElytronRESPAuthenticator
implements Authenticator {
    private final String name;
    private SecurityDomain securityDomain;
    private BlockingManager blockingManager;

    public ElytronRESPAuthenticator(String name) {
        this.name = name;
    }

    public static void init(RespServerConfiguration configuration, ServerConfiguration serverConfiguration, BlockingManager blockingManager) {
        ElytronRESPAuthenticator authenticator = (ElytronRESPAuthenticator)configuration.authentication().authenticator();
        if (authenticator != null) {
            authenticator.init(serverConfiguration, blockingManager);
        }
    }

    private void init(ServerConfiguration serverConfiguration, BlockingManager blockingManager) {
        this.securityDomain = serverConfiguration.security().realms().getRealm(this.name).serverSecurityRealm().getSecurityDomain();
        this.blockingManager = blockingManager;
    }

    public CompletionStage<Subject> authenticate(String username, char[] password) {
        return this.blockingManager.supplyBlocking(() -> {
            try {
                SecurityIdentity securityIdentity = this.securityDomain.authenticate(username, (Evidence)new PasswordGuessEvidence(password));
                Subject subject = new Subject();
                subject.getPrincipals().add(securityIdentity.getPrincipal());
                securityIdentity.getRoles().forEach(r -> subject.getPrincipals().add(new RolePrincipal((String)r)));
                return subject;
            }
            catch (RealmUnavailableException e) {
                throw new RuntimeException(e);
            }
        }, (Object)"resp-auth");
    }
}

