/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.configuration.attributes.PropertiesAttributeSerializer;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.ServerConfigurationSerializer;
import org.infinispan.server.configuration.security.CredentialStoresConfiguration;
import org.wildfly.security.credential.source.CredentialSource;

public class DataSourceConfiguration
extends ConfigurationElement<DataSourceConfiguration> {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((Enum)Attribute.NAME, null, String.class).build();
    static final AttributeDefinition<String> JNDI_NAME = AttributeDefinition.builder((Enum)Attribute.JNDI_NAME, null, String.class).build();
    static final AttributeDefinition<Boolean> STATISTICS = AttributeDefinition.builder((Enum)Attribute.STATISTICS, (Object)false, Boolean.class).build();
    static final AttributeDefinition<String> DRIVER = AttributeDefinition.builder((Enum)Attribute.DRIVER, null, String.class).build();
    static final AttributeDefinition<String> URL = AttributeDefinition.builder((Enum)Attribute.URL, null, String.class).build();
    static final AttributeDefinition<String> USERNAME = AttributeDefinition.builder((Enum)Attribute.USERNAME, null, String.class).build();
    static final AttributeDefinition<Supplier<CredentialSource>> PASSWORD = AttributeDefinition.builder((Enum)Attribute.PASSWORD, null, Supplier.class).serializer(ServerConfigurationSerializer.CREDENTIAL).build();
    static final AttributeDefinition<String> INITIAL_SQL = AttributeDefinition.builder((Enum)Attribute.NEW_CONNECTION_SQL, null, String.class).build();
    static final AttributeDefinition<AgroalConnectionFactoryConfiguration.TransactionIsolation> TRANSACTION_ISOLATION = AttributeDefinition.builder((Enum)Attribute.TRANSACTION_ISOLATION, (Object)AgroalConnectionFactoryConfiguration.TransactionIsolation.READ_COMMITTED, AgroalConnectionFactoryConfiguration.TransactionIsolation.class).build();
    static final AttributeDefinition<Integer> MAX_SIZE = AttributeDefinition.builder((Enum)Attribute.MAX_SIZE, null, Integer.class).build();
    static final AttributeDefinition<Integer> MIN_SIZE = AttributeDefinition.builder((Enum)Attribute.MIN_SIZE, (Object)0, Integer.class).build();
    static final AttributeDefinition<Integer> INITIAL_SIZE = AttributeDefinition.builder((Enum)Attribute.INITIAL_SIZE, (Object)0, Integer.class).build();
    static final AttributeDefinition<Long> BLOCKING_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.BLOCKING_TIMEOUT, (Object)0L, Long.class).build();
    static final AttributeDefinition<Long> BACKGROUND_VALIDATION = AttributeDefinition.builder((Enum)Attribute.BACKGROUND_VALIDATION, (Object)0L, Long.class).build();
    static final AttributeDefinition<Long> VALIDATE_ON_ACQUISITION = AttributeDefinition.builder((Enum)Attribute.VALIDATE_ON_ACQUISITION, (Object)0L, Long.class).build();
    static final AttributeDefinition<Long> LEAK_DETECTION = AttributeDefinition.builder((Enum)Attribute.LEAK_DETECTION, (Object)0L, Long.class).build();
    static final AttributeDefinition<Integer> IDLE_REMOVAL = AttributeDefinition.builder((Enum)Attribute.IDLE_REMOVAL, (Object)0, Integer.class).build();
    static final AttributeDefinition<Map<String, String>> CONNECTION_PROPERTIES = AttributeDefinition.builder((Enum)Element.CONNECTION_PROPERTY, null, Map.class).initializer(LinkedHashMap::new).serializer((AttributeSerializer)new PropertiesAttributeSerializer((Enum)Element.CONNECTION_PROPERTIES, (Enum)Element.CONNECTION_PROPERTY, (Enum)Attribute.NAME)).immutable().build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(DataSourceConfiguration.class, new AttributeDefinition[]{NAME, JNDI_NAME, STATISTICS, DRIVER, URL, USERNAME, PASSWORD, INITIAL_SQL, TRANSACTION_ISOLATION, MAX_SIZE, MIN_SIZE, INITIAL_SIZE, BLOCKING_TIMEOUT, BACKGROUND_VALIDATION, VALIDATE_ON_ACQUISITION, LEAK_DETECTION, IDLE_REMOVAL, CONNECTION_PROPERTIES});
    }

    DataSourceConfiguration(AttributeSet attributes) {
        super((Enum)Element.DATA_SOURCE, attributes, new ConfigurationElement[0]);
    }

    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public String jndiName() {
        return (String)this.attributes.attribute(JNDI_NAME).get();
    }

    public Boolean statistics() {
        return (Boolean)this.attributes.attribute(STATISTICS).get();
    }

    public String driver() {
        return (String)this.attributes.attribute(DRIVER).get();
    }

    public String username() {
        return (String)this.attributes.attribute(USERNAME).get();
    }

    public char[] password() {
        return CredentialStoresConfiguration.resolvePassword((org.infinispan.commons.configuration.attributes.Attribute<Supplier<CredentialSource>>)this.attributes.attribute(PASSWORD));
    }

    public String url() {
        return (String)this.attributes.attribute(URL).get();
    }

    public AgroalConnectionFactoryConfiguration.TransactionIsolation transactionIsolation() {
        return (AgroalConnectionFactoryConfiguration.TransactionIsolation)this.attributes.attribute(TRANSACTION_ISOLATION).get();
    }

    public String initialSql() {
        return (String)this.attributes.attribute(INITIAL_SQL).get();
    }

    public int maxSize() {
        return (Integer)this.attributes.attribute(MAX_SIZE).get();
    }

    public int minSize() {
        return (Integer)this.attributes.attribute(MIN_SIZE).get();
    }

    public int initialSize() {
        return (Integer)this.attributes.attribute(INITIAL_SIZE).get();
    }

    public long blockingTimeout() {
        return (Long)this.attributes.attribute(BLOCKING_TIMEOUT).get();
    }

    public long backgroundValidation() {
        return (Long)this.attributes.attribute(BACKGROUND_VALIDATION).get();
    }

    public long validateOnAcquisition() {
        return (Long)this.attributes.attribute(VALIDATE_ON_ACQUISITION).get();
    }

    public long leakDetection() {
        return (Long)this.attributes.attribute(LEAK_DETECTION).get();
    }

    public int idleRemoval() {
        return (Integer)this.attributes.attribute(IDLE_REMOVAL).get();
    }

    public Map<String, String> connectionProperties() {
        return (Map)this.attributes.attribute(CONNECTION_PROPERTIES).get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DataSourceConfiguration that = (DataSourceConfiguration)((Object)o);
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return "DataSourceConfiguration{attributes=" + this.attributes + "}";
    }
}

