/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.LdapAttributeConfiguration;
import org.infinispan.server.configuration.security.LdapAttributeConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapIdentityMappingConfiguration;
import org.infinispan.server.configuration.security.LdapRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapUserPasswordMapperConfigurationBuilder;

public class LdapIdentityMappingConfigurationBuilder
implements Builder<LdapIdentityMappingConfiguration> {
    private final AttributeSet attributes;
    private final List<LdapAttributeConfigurationBuilder> attributeMappings = new ArrayList<LdapAttributeConfigurationBuilder>();
    private final LdapUserPasswordMapperConfigurationBuilder userPasswordMapper;

    LdapIdentityMappingConfigurationBuilder(LdapRealmConfigurationBuilder ldapConfigurationBuilder) {
        this.userPasswordMapper = new LdapUserPasswordMapperConfigurationBuilder(ldapConfigurationBuilder);
        this.attributes = LdapIdentityMappingConfiguration.attributeDefinitionSet();
    }

    public LdapIdentityMappingConfigurationBuilder rdnIdentifier(String rdnIdentifier) {
        this.attributes.attribute(LdapIdentityMappingConfiguration.RDN_IDENTIFIER).set((Object)rdnIdentifier);
        return this;
    }

    public LdapIdentityMappingConfigurationBuilder searchBaseDn(String searchBaseDn) {
        this.attributes.attribute(LdapIdentityMappingConfiguration.SEARCH_BASE_DN).set((Object)searchBaseDn);
        return this;
    }

    public LdapIdentityMappingConfigurationBuilder searchRecursive(boolean searchRecursive) {
        this.attributes.attribute(LdapAttributeConfiguration.SEARCH_RECURSIVE).set((Object)searchRecursive);
        return this;
    }

    public LdapIdentityMappingConfigurationBuilder searchTimeLimit(int searchTimeLimit) {
        this.attributes.attribute(LdapIdentityMappingConfiguration.SEARCH_TIME_LIMIT).set((Object)searchTimeLimit);
        return this;
    }

    public LdapIdentityMappingConfigurationBuilder filterName(String filterName) {
        this.attributes.attribute(LdapIdentityMappingConfiguration.FILTER_NAME).set((Object)filterName);
        return this;
    }

    public LdapAttributeConfigurationBuilder addAttributeMapping() {
        LdapAttributeConfigurationBuilder builder = new LdapAttributeConfigurationBuilder();
        this.attributeMappings.add(builder);
        return builder;
    }

    public LdapUserPasswordMapperConfigurationBuilder userPasswordMapper() {
        return this.userPasswordMapper;
    }

    public void validate() {
        this.attributeMappings.forEach(Builder::validate);
        this.userPasswordMapper.validate();
    }

    public LdapIdentityMappingConfiguration create() {
        List<LdapAttributeConfiguration> mappingConfigurations = this.attributeMappings.stream().map(LdapAttributeConfigurationBuilder::create).collect(Collectors.toList());
        return new LdapIdentityMappingConfiguration(this.attributes.protect(), mappingConfigurations, this.userPasswordMapper.create());
    }

    public LdapIdentityMappingConfigurationBuilder read(LdapIdentityMappingConfiguration template) {
        this.attributes.read(template.attributes());
        this.attributeMappings.clear();
        template.attributeMappings().forEach(a -> this.addAttributeMapping().read((LdapAttributeConfiguration)((Object)a)));
        this.userPasswordMapper.read(template.userPasswordMapper());
        return this;
    }
}

