/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Properties;
import java.util.function.Supplier;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.CredentialStoresConfiguration;
import org.infinispan.server.security.ElytronPasswordProviderSupplier;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.source.impl.CommandCredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.CredentialStoreSpi;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.util.PasswordBasedEncryptionUtil;

public class CredentialStoreConfiguration
extends ConfigurationElement<CredentialStoresConfiguration> {
    public static final AttributeDefinition<String> NAME = AttributeDefinition.builder((Enum)Attribute.NAME, null, String.class).build();
    public static final AttributeDefinition<String> PATH = AttributeDefinition.builder((Enum)Attribute.PATH, null, String.class).build();
    public static final AttributeDefinition<String> RELATIVE_TO = AttributeDefinition.builder((Enum)Attribute.RELATIVE_TO, (Object)"infinispan.server.config.path", String.class).autoPersist(false).build();
    public static final AttributeDefinition<String> TYPE = AttributeDefinition.builder((Enum)Attribute.TYPE, (Object)"pkcs12", String.class).build();
    static final AttributeDefinition<Supplier<CredentialSource>> CREDENTIAL = AttributeDefinition.builder((Enum)Attribute.CREDENTIAL, null, Supplier.class).serializer((writer, name, value) -> ((AttributeSerializer)value).serialize(writer, name, null)).build();
    private CredentialStoreSpi credentialStore;

    static AttributeSet attributeDefinitionSet() {
        KeyStore.getDefaultType();
        return new AttributeSet(CredentialStoreConfiguration.class, new AttributeDefinition[]{NAME, PATH, RELATIVE_TO, TYPE, CREDENTIAL});
    }

    CredentialStoreConfiguration(AttributeSet attributes) {
        super((Enum)Element.CREDENTIAL_STORE, attributes, new ConfigurationElement[0]);
    }

    void init(Properties properties) {
        block4: {
            if (this.credentialStore == null) {
                if (this.attributes.attribute(PATH).isNull()) {
                    throw new IllegalStateException("file has to be specified");
                }
                String path = (String)this.attributes.attribute(PATH).get();
                String relativeTo = properties.getProperty((String)this.attributes.attribute(RELATIVE_TO).get());
                String location = ParseUtils.resolvePath((String)path, (String)relativeTo);
                this.credentialStore = new KeyStoreCredentialStore();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("location", location);
                map.put("create", "false");
                map.put("keyStoreType", (String)this.attributes.attribute(TYPE).get());
                try {
                    CredentialSource credential = (CredentialSource)((Supplier)this.attributes.attribute(CREDENTIAL).get()).get();
                    this.credentialStore.initialize(map, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential(credential.getCredential(PasswordCredential.class))), ElytronPasswordProviderSupplier.PROVIDERS);
                }
                catch (Exception e) {
                    if (e.getMessage().startsWith("ELY09518")) break block4;
                    throw new CacheConfigurationException(e);
                }
            }
        }
    }

    public <C extends Credential> C getCredential(String alias, Class<C> type) {
        try {
            if (alias == null) {
                if (this.credentialStore.getAliases().size() == 1) {
                    alias = (String)this.credentialStore.getAliases().iterator().next();
                } else {
                    throw Server.log.unspecifiedCredentialAlias();
                }
            }
            return (C)this.credentialStore.retrieve(alias, type, null, null, null);
        }
        catch (CredentialStoreException e) {
            throw new CacheConfigurationException((Exception)((Object)e));
        }
    }

    public static class CommandCredentialSupplier
    implements Supplier<CredentialSource>,
    AttributeSerializer<CommandCredentialSupplier> {
        private final String command;
        private final CommandCredentialSource source;

        public CommandCredentialSupplier(String command) {
            String[] parsedCommands;
            this.command = command;
            CommandCredentialSource.Builder builder = CommandCredentialSource.builder();
            builder.setPasswordFactoryProvider((Provider)WildFlyElytronPasswordProvider.getInstance());
            for (String parsedCommand : parsedCommands = command.split("(?<!\\\\) ")) {
                if (parsedCommand.indexOf(92) != -1) {
                    builder.addCommand(parsedCommand.replaceAll("\\\\ ", " "));
                    continue;
                }
                builder.addCommand(parsedCommand);
            }
            try {
                this.source = builder.build();
            }
            catch (GeneralSecurityException e) {
                throw new CacheConfigurationException((Exception)e);
            }
        }

        @Override
        public CredentialSource get() {
            return this.source;
        }

        public void serialize(ConfigurationWriter writer, String name, CommandCredentialSupplier value) {
            writer.writeStartElement((Enum)Element.COMMAND_CREDENTIAL);
            writer.writeAttribute((Enum)Attribute.COMMAND, this.command);
            writer.writeEndElement();
        }
    }

    public static class MaskedCredentialSupplier
    implements Supplier<CredentialSource>,
    AttributeSerializer<MaskedCredentialSupplier> {
        private final CredentialSource credential;
        private final String masked;

        public MaskedCredentialSupplier(String masked) {
            int iterationCount;
            this.masked = masked;
            String[] part = masked.split(";");
            if (part.length != 3) {
                throw Server.log.wrongMaskedPasswordFormat();
            }
            String salt = part[1];
            try {
                iterationCount = Integer.parseInt(part[2]);
            }
            catch (NumberFormatException e) {
                throw Server.log.wrongMaskedPasswordFormat();
            }
            try {
                PasswordBasedEncryptionUtil pbe = new PasswordBasedEncryptionUtil.Builder().picketBoxCompatibility().salt(salt).iteration(iterationCount).decryptMode().build();
                this.credential = new ClearTextCredentialSource(pbe.decodeAndDecrypt(part[0]));
            }
            catch (GeneralSecurityException e) {
                throw new CacheConfigurationException((Exception)e);
            }
        }

        @Override
        public CredentialSource get() {
            return this.credential;
        }

        public void serialize(ConfigurationWriter writer, String name, MaskedCredentialSupplier value) {
            writer.writeStartElement((Enum)Element.MASKED_CREDENTIAL);
            writer.writeAttribute((Enum)Attribute.MASKED, this.masked);
            writer.writeEndElement();
        }
    }

    public static class ClearTextCredentialSupplier
    implements Supplier<CredentialSource>,
    AttributeSerializer<ClearTextCredentialSupplier> {
        private final ClearTextCredentialSource credential;

        public ClearTextCredentialSupplier(char[] credential) {
            this.credential = new ClearTextCredentialSource(credential);
        }

        @Override
        public CredentialSource get() {
            return this.credential;
        }

        public void serialize(ConfigurationWriter writer, String name, ClearTextCredentialSupplier value) {
            writer.writeStartElement((Enum)Element.CLEAR_TEXT_CREDENTIAL);
            if (writer.clearTextSecrets()) {
                writer.writeAttribute((Enum)Attribute.CLEAR_TEXT, new String(this.credential.secret));
            } else {
                writer.writeAttribute(name, "***");
            }
            writer.writeEndElement();
        }
    }

    public static class ClearTextCredentialSource
    implements CredentialSource {
        final char[] secret;

        public ClearTextCredentialSource(char[] secret) {
            this.secret = secret;
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            return credentialType == PasswordCredential.class ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
        }

        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            return (C)((Credential)credentialType.cast(new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])this.secret))));
        }
    }
}

